package com.instabug.featuresrequest.eventbus;

import android.annotation.SuppressLint;

import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.library.core.eventbus.EventBus;

import androidx.annotation.VisibleForTesting;

/**
 * @author hossam.
 */
public class FeatureRequestsEventBus extends EventBus<FeatureRequest> {
    private static volatile FeatureRequestsEventBus featureRequestsEventBus;
    private FeatureRequestsEventBus() {
        if (featureRequestsEventBus != null) {
            throw new RuntimeException("Use getInstance() method to get the single instance" +
                    " of this class");
        }
    }

    public static FeatureRequestsEventBus getInstance() {
        if (featureRequestsEventBus == null) {
            synchronized (FeatureRequestsEventBus.class) {
                if (featureRequestsEventBus == null)
                    featureRequestsEventBus = new FeatureRequestsEventBus();
            }
        }
        return featureRequestsEventBus;
    }

    @VisibleForTesting
    @SuppressLint("ERADICATE_FIELD_NOT_NULLABLE")
    static void tearDown(){
        featureRequestsEventBus = null;
    }
    //Make singleton from serialize and deserialize operation.
    protected FeatureRequestsEventBus readResolve() {
        return getInstance();
    }
}
