package com.instabug.featuresrequest.ui.custom;

import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;

public class ToolbarActionButton {
    private
    @DrawableRes
    int icon;

    private
    @StringRes
    int title;

    private OnToolbarButtonClick onToolbarButtonClick;
    private ViewType viewType;

    public ToolbarActionButton(int icon, int title, OnToolbarButtonClick onToolbarButtonClick,
                               ViewType viewType) {
        this.icon = icon;
        this.title = title;
        this.onToolbarButtonClick = onToolbarButtonClick;
        this.viewType = viewType;
    }

    public int getIcon() {
        return icon;
    }

    public void setIcon(int icon) {
        this.icon = icon;
    }

    public int getTitle() {
        return title;
    }

    public void setTitle(int title) {
        this.title = title;
    }

    public OnToolbarButtonClick getOnToolbarButtonClick() {
        return onToolbarButtonClick;
    }

    public void setOnToolbarButtonClick(OnToolbarButtonClick onToolbarButtonClick) {
        this.onToolbarButtonClick = onToolbarButtonClick;
    }

    public ViewType getViewType() {
        return viewType;
    }

    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    public enum ViewType {
        ICON(0), TEXT(1), VOTE(2);
        private int type;

        ViewType(int type) {
            this.type = type;
        }

        public int toInt() {
            return type;
        }
    }

    public interface OnToolbarButtonClick {
        void onClick();
    }
}