package com.instabug.featuresrequest.network.timelinerepository;

import android.content.Context;

import androidx.annotation.Nullable;

import com.instabug.featuresrequest.Constants;
import com.instabug.featuresrequest.models.NewComment;
import com.instabug.featuresrequest.models.TimelineResponse;
import com.instabug.featuresrequest.network.service.FeaturesRequestService;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by mzelzoghbi on 2/15/18.
 */

public class FeatureRequestsRepository implements FeatureRequestRepositoryContract {
    private static FeatureRequestsRepository INSTANCE;

    public static FeatureRequestsRepository getInstance() {
        return INSTANCE != null ? INSTANCE : (INSTANCE = new FeatureRequestsRepository());
    }

    @Override
    public void getFeatureTimeline(final long featureId,
                                   final RepositoryObserver<TimelineResponse> responseTimelineObserver) {
        // network request
        try {
            FeaturesRequestService.getInstance().getFeatureTimeLine(featureId, new Request.Callbacks<JSONObject, Throwable>() {
                @Override
                public void onSucceeded(@Nullable JSONObject response) {
                    if (response == null) {
                        onFailed(new JSONException("response json is null"));
                        return;
                    }

                    try {
                        TimelineResponse timeline = TimelineResponse.fromJson(response);
                        timeline.setFeatureId(featureId);
                        responseTimelineObserver.onDataChanged(timeline);
                    } catch (JSONException e) {
                    }
                }

                @Override
                public void onFailed(Throwable error) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, error.getMessage() != null
                            ? error.getMessage()
                            : "something went wrong while getting feature timeline", error);
                    responseTimelineObserver.onError(error);
                }
            });
        } catch (Exception error) {
            InstabugSDKLogger.e(Constants.LOG_TAG, error.getMessage() != null
                    ? error.getMessage()
                    : "something went wrong while getting feature timeline", error);
        }
    }

    @Override
    public void addComment(NewComment newComment, final RepositoryObserver<JSONObject> responseTimelineObserver) {
        // network request
        try {
            FeaturesRequestService.getInstance().addComment(newComment, new Request.Callbacks<JSONObject, Throwable>() {
                @Override
                public void onSucceeded(@Nullable JSONObject response) {
                    if (response != null)
                        responseTimelineObserver.onDataChanged(response);

                }

                @Override
                public void onFailed(Throwable error) {
                    InstabugSDKLogger.e(Constants.LOG_TAG,
                            error.getMessage() != null
                                    ? error.getMessage()
                                    : "something went wrong while trying to add new comment", error);
                    responseTimelineObserver.onError(error);
                }
            });
        } catch (Exception error) {
            InstabugSDKLogger.e(Constants.LOG_TAG, error.getMessage() != null
                    ? error.getMessage()
                    : "something went wrong while trying to add new comment", error);
        }
    }
}
