package com.instabug.featuresrequest.ui.featurerequests;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.listeners.OnListClickListener;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.ui.custom.IbFrRippleView;
import com.instabug.featuresrequest.utils.DateUtils;
import com.instabug.featuresrequest.utils.FormatterUtils;
import com.instabug.featuresrequest.utils.StatusBinder;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AttrResolver;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

import static com.instabug.featuresrequest.utils.DrawableUtils.setColor;

/**
 * Created by mohamedzakaria on 8/28/17.
 */
// todo remove if not used after search refactoring
public class FeaturesRequestAdapter extends BaseAdapter {
    private final OnListClickListener onListClickListener;
    private final List<FeatureRequest> featureRequestList;

    public FeaturesRequestAdapter(@NonNull List<FeatureRequest> featureRequestList,
                                  @NonNull OnListClickListener onListClickListener) {
        this.featureRequestList = featureRequestList;
        this.onListClickListener = onListClickListener;
    }

    @Override
    public int getCount() {
        return featureRequestList.size();
    }

    @Override
    public FeatureRequest getItem(int position) {
        return featureRequestList.get(position);
    }

    @Override
    public long getItemId(int position) {
        return getItem(position).getFeatureId();
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.ib_fr_feature_request_item,
                            parent, false);
            viewHolder = new ViewHolder(convertView);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        bind(convertView.getContext(), viewHolder, getItem(position));

        convertView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onListClickListener.onFeatureClicked(getItem(position));
            }
        });
        return convertView;
    }


    protected void bind(Context context, final ViewHolder viewHolder, final FeatureRequest item) {

        String title = item.getTitle();
        if (viewHolder.title != null) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                viewHolder.title.setText(Html.fromHtml(title, Html.FROM_HTML_MODE_COMPACT));
            } else {
                viewHolder.title.setText(Html.fromHtml(title));
            }
        }

        if (viewHolder.votesCount != null)
            viewHolder.votesCount.setText(FormatterUtils.formatNumber(String.valueOf(item
                    .getLikesCount())));
        if (viewHolder.commentsCount != null)
            viewHolder.commentsCount.setText(String.valueOf(item.getCommentsCount()));
        if (viewHolder.date != null)
            viewHolder.date.setText(DateUtils.getTimeAgo(context, item.getDate()));

        StatusBinder.bind(item.getStatus(), item.getColorCode(), viewHolder.status, context);

        if (viewHolder.voteIcon != null && viewHolder.voteText != null && viewHolder.votesCount != null) {
            if (item.isLiked()) {
                setColor(viewHolder.voteLayout, SettingsManager.getInstance().getPrimaryColor());
                viewHolder.votesCount.setTextColor(ContextCompat.getColor(context, android.R.color
                        .white));
                viewHolder.voteIcon.setImageResource(R.drawable.ibg_fr_ic_vote_arrow_white);
                viewHolder.voteText.setTextColor(ContextCompat.getColor(context, android.R.color
                        .white));
            } else {
                setColor(viewHolder.voteLayout, android.R.color.white);
                if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                    viewHolder.voteIcon.setImageResource(R.drawable.ibg_fr_ic_vote_arrow);
                    viewHolder.votesCount.setTextColor(ContextCompat.getColor(context, R.color
                            .ib_fr_color_ptr_loading_txt));
                    viewHolder.voteText.setTextColor(ContextCompat.getColor(context, R.color
                            .ib_fr_color_ptr_loading_txt));
                } else {
                    viewHolder.voteIcon.setImageResource(R.drawable.ibg_fr_ic_vote_arrow_dark);
                    viewHolder.votesCount.setTextColor(AttrResolver.getColor(context, R.attr
                            .instabug_fr_text_color));
                    viewHolder.voteText.setTextColor(AttrResolver.getColor(context, R.attr
                            .instabug_fr_text_color));
                }
            }
        }

        if (viewHolder.voteLayout != null) {
            viewHolder.voteLayout.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (item.isLiked()) {
                        item.setLikesCount(item.getLikesCount() - 1);
                        item.setLiked(false);
                        onListClickListener.onUnVote(item);
                        ((IbFrRippleView)v).setRippleColor(Color.parseColor("#888888"));
                    } else {
                        item.setLiked(true);
                        item.setLikesCount(item.getLikesCount() + 1);
                        onListClickListener.onVote(item);
                        ((IbFrRippleView)v).setRippleColor(Color.parseColor("#ffffff"));
                    }
                    notifyDataSetChanged();
                }
            });
        }

    }

    public void add(List<FeatureRequest> features) {
        featureRequestList.addAll(features);
    }

    public static class ViewHolder {
        @Nullable
        public final TextView voteText;
        @Nullable
        public final ImageView voteIcon;
        @Nullable
        public final TextView title;
        @Nullable
        public final TextView votesCount;
        @Nullable
        public final TextView commentsCount;
        @Nullable
        public final TextView status;
        @Nullable
        public final TextView date;
        @Nullable
        public final IbFrRippleView voteLayout;

        ViewHolder(View view) {
            voteText = view.findViewById(R.id
                    .instabug_txt_feature_request_vote_txt);
            voteIcon = view.findViewById(R.id
                    .instabug_txt_feature_request_vote_icon);
            title = view.findViewById(R.id
                    .instabug_txt_feature_request_title);
            votesCount = view.findViewById(R.id
                    .instabug_txt_feature_request_vote_count);
            commentsCount = view.findViewById(R.id
                    .instabug_txt_feature_request_comment_count);
            status = view.findViewById(R.id
                    .instabug_txt_feature_request_status);
            date = view.findViewById(R.id
                    .instabug_txt_feature_request_date);
            voteLayout = view.findViewById(R.id
                    .ib_btn_fr_vote);

        }

    }

}
