/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.crash.a.a;
import com.instabug.crash.b.b;
import com.instabug.crash.models.Crash;
import com.instabug.crash.network.InstabugCrashesUploaderService;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.WriteStateToFileDiskOperation;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.model.Report;
import com.instabug.library.model.State;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ReportHelper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashReporting {
    public static void reportException(Throwable throwable) {
        APIBuildChecker.check();
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        CrashReporting.createFormattedException(throwable, null);
    }

    public static void createFormattedException(Throwable throwable, String string) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("error", (Object)com.instabug.crash.d.b.a(throwable, string));
            CrashReporting.reportException(jSONObject, true);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private static void reportException(JSONObject jSONObject, boolean bl) {
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        if (SettingsManager.getInstance().getPreReportRunnable() != null) {
            try {
                SettingsManager.getInstance().getPreReportRunnable().run();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(CrashReporting.class, (String)"Pre sending runnable failed to run.", (Throwable)exception);
            }
        }
        Context context = Instabug.getApplicationContext();
        State state = State.getState((Context)context);
        SettingsManager settingsManager = SettingsManager.getInstance();
        Report report = CrashReporting.getReport(settingsManager);
        Crash crash = CrashReporting.getCrash(jSONObject, bl, context, state);
        ReportHelper.update((State)crash.e(), (Report)report);
        if (InstabugCore.getExtraAttachmentFiles().size() >= 1) {
            CrashReporting.addCrashAttachments(context, crash);
        }
        if (b.a().isEnabled() && SettingsManager.getInstance().autoScreenRecordingEnabled()) {
            CrashReporting.stopAutoScreenRecordingAndAttach(crash);
        }
        if (context != null) {
            File file = DiskUtils.createStateTextFile((Context)context);
            CrashReporting.createStateTextFile(context, crash, file);
        }
        InstabugSDKLogger.i(CrashReporting.class, (String)"ReportCaughtException: Your exception has been reported");
        InstabugCrashesUploaderService.a(context, new Intent(context, InstabugCrashesUploaderService.class));
        b.a().b();
    }

    private static void createStateTextFile(Context context, Crash crash, File file) {
        try {
            Uri uri = DiskUtils.with((Context)context).writeOperation((DiskOperation)new WriteStateToFileDiskOperation(file, crash.e().toJson())).execute();
            crash.e().setUri(uri);
            AttachmentsUtility.encryptAttachments(crash.d());
            a.a(crash);
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e(CrashReporting.class, (String)jSONException.toString());
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(CrashReporting.class, (String)iOException.toString());
        }
    }

    public static void stopAutoScreenRecordingAndAttach(Crash crash) {
        AutoScreenRecordingEventBus.getInstance().post((Object)ScreenRecordingService.Action.STOP_KEEP);
        com.instabug.crash.b.a.a(crash);
    }

    public static void addCrashAttachments(Context context, Crash crash) {
        for (Map.Entry entry : InstabugCore.getExtraAttachmentFiles().entrySet()) {
            Uri uri = AttachmentsUtility.getNewFileAttachmentUri((Context)context, (Uri)((Uri)entry.getKey()), (String)((String)entry.getValue()));
            crash.a(uri);
        }
    }

    @NonNull
    public static Crash getCrash(JSONObject jSONObject, boolean bl, Context context, State state) {
        Crash crash = new Crash.a().a(context, state);
        crash.c(jSONObject.toString());
        crash.a(Crash.CrashState.READY_TO_BE_SENT);
        crash.a(bl);
        return crash;
    }

    @NonNull
    public static Report getReport(SettingsManager settingsManager) {
        Report report = new Report();
        if (settingsManager.getOnReportCreatedListener() != null) {
            settingsManager.getOnReportCreatedListener().onReportCreated(report);
        }
        return report;
    }

    public static void reportException(Throwable throwable, @Nullable String string) {
        APIBuildChecker.check();
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        CrashReporting.createFormattedException(throwable, string);
    }

    private static void reportUncaughtException(JSONObject jSONObject) {
        CrashReporting.reportException(jSONObject, false);
    }
}

