/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.network;

import android.content.Context;
import com.instabug.crash.cache.CrashesCacheManager;
import com.instabug.crash.models.Crash;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;
import rx.Observable;
import rx.Subscriber;

public final class a {
    private static a a;
    private NetworkManager b = new NetworkManager();

    private a() {
    }

    public static a a() {
        if (a == null) {
            a = new a();
        }
        return a;
    }

    public final void a(Context context, Crash crash, Request.Callbacks<String, Throwable> callbacks) throws JSONException, IOException {
        ArrayList arrayList;
        InstabugSDKLogger.d((Object)this, (String)("Reporting crash with crash message: " + crash.c()));
        context = this.b.buildRequest(context, Request.Endpoint.ReportCrash, Request.RequestMethod.Post);
        if (crash.c() != null && crash.c().contains("InstabugSDK-v: ")) {
            context.addRequestBodyParameter("application_token", (Object)"b1a9630002b2cbdfbfecd942744b9018");
        }
        if ((arrayList = crash.e().getStateItems()) != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                InstabugSDKLogger.d((Object)this, (String)("Crash State Key: " + ((State.StateItem)arrayList.get(i)).getKey() + ", Crash State value: " + ((State.StateItem)arrayList.get(i)).getValue()));
                context.addRequestBodyParameter(((State.StateItem)arrayList.get(i)).getKey(), ((State.StateItem)arrayList.get(i)).getValue());
            }
        }
        context.addRequestBodyParameter("title", (Object)crash.c());
        context.addRequestBodyParameter("attachments_count", (Object)crash.d().size());
        context.addRequestBodyParameter("handled", (Object)crash.g());
        this.b.doRequest((Request)context).subscribe((Subscriber)new Subscriber<RequestResponse>(this, callbacks){
            private /* synthetic */ Request.Callbacks a;
            {
                this.a = callbacks;
            }

            public final void onStart() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"reportingCrashRequest started");
            }

            public final void onCompleted() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"reportingCrashRequest completed");
            }

            public final void onError(Throwable throwable) {
                InstabugSDKLogger.d((Object)((Object)this), (String)("reportingCrashRequest got error: " + throwable.getMessage()));
                this.a.onFailed((Object)throwable);
            }

            public final /* synthetic */ void onNext(Object object) {
                RequestResponse requestResponse = (RequestResponse)object;
                object = this;
                InstabugSDKLogger.v((Object)object, (String)("reportingCrashRequest onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
                try {
                    object.a.onSucceeded((Object)new JSONObject((String)requestResponse.getResponseBody()).getString("id"));
                    return;
                }
                catch (JSONException jSONException) {
                    object = jSONException;
                    jSONException.printStackTrace();
                    return;
                }
            }
        });
    }

    public final void b(Context context, Crash crash, Request.Callbacks<Boolean, Crash> callbacks) throws JSONException, FileNotFoundException {
        InstabugSDKLogger.d((Object)this, (String)"Uploading Crash attachments");
        Observable[] observableArray = new Observable[crash.d().size()];
        for (int i = 0; i < observableArray.length; ++i) {
            Attachment attachment = crash.d().get(i);
            Request request = this.b.buildRequest(context, Request.Endpoint.AddCrashAttachment, Request.RequestMethod.Post, NetworkManager.RequestType.MULTI_PART);
            request.setEndpoint(request.getEndpoint().replaceAll(":crash_token", crash.b()));
            request.addParameter("metadata[file_type]", (Object)attachment.getType());
            if (attachment.getType() == Attachment.Type.AUDIO) {
                request.addParameter("metadata[duration]", (Object)attachment.getDuration());
            }
            request.setFileToUpload(new Request.FileToUpload("file", attachment.getName(), attachment.getLocalPath(), attachment.getFileType()));
            observableArray[i] = this.b.doRequest(request);
        }
        Observable.merge((Observable[])observableArray, (int)1).subscribe((Subscriber)new Subscriber<RequestResponse>(this, crash, callbacks){
            private /* synthetic */ Crash a;
            private /* synthetic */ Request.Callbacks b;
            {
                this.a = crash;
                this.b = callbacks;
            }

            public final void onStart() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"uploadingCrashAttachmentRequest started");
            }

            public final void onCompleted() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"uploadingCrashAttachmentRequest completed");
                if (this.a.d().size() == 0) {
                    this.b.onSucceeded((Object)true);
                }
            }

            public final void onError(Throwable throwable) {
                InstabugSDKLogger.d((Object)((Object)this), (String)("uploadingCrashAttachmentRequest got error: " + throwable.getMessage()));
                this.b.onFailed((Object)this.a);
            }

            public final /* synthetic */ void onNext(Object object) {
                Object object2 = (RequestResponse)object;
                object = this;
                InstabugSDKLogger.v((Object)object, (String)("uploadingCrashAttachmentRequest onNext, Response code: " + object2.getResponseCode() + ", Response body: " + object2.getResponseBody()));
                object2 = new File(object.a.d().get(0).getLocalPath());
                boolean bl = object2.delete();
                Attachment attachment = object.a.d().remove(0);
                if (!bl) {
                    InstabugSDKLogger.e((Object)object, (String)("Attachment: " + attachment + " is not removed"));
                } else {
                    InstabugSDKLogger.d((Object)object, (String)("Attachment: " + attachment + " is removed"));
                }
                CrashesCacheManager.addCrash(object.a);
                CrashesCacheManager.saveCacheToDisk();
            }
        });
    }

    public final void c(Context context, Crash crash, Request.Callbacks<Boolean, Crash> callbacks) {
        try {
            context = this.b.buildRequest(context, Request.Endpoint.crashLogs, Request.RequestMethod.Post);
            context.setEndpoint(context.getEndpoint().replaceAll(":crash_token", crash.b()));
            Object object = crash.e().getLogsItems();
            if (object != null && ((ArrayList)object).size() > 0) {
                object = ((ArrayList)object).iterator();
                while (object.hasNext()) {
                    State.StateItem stateItem = (State.StateItem)object.next();
                    context.addRequestBodyParameter(stateItem.getKey(), stateItem.getValue());
                }
            }
            this.b.doRequest((Request)context).subscribe((Subscriber)new Subscriber<RequestResponse>(this, callbacks, crash){
                private /* synthetic */ Request.Callbacks a;
                private /* synthetic */ Crash b;
                {
                    this.a = callbacks;
                    this.b = crash;
                }

                public final void onStart() {
                    InstabugSDKLogger.d((Object)((Object)this), (String)"uploading crash logs started");
                }

                public final void onCompleted() {
                    InstabugSDKLogger.d((Object)((Object)this), (String)"uploading crash logs completed");
                    this.a.onSucceeded((Object)true);
                }

                public final void onError(Throwable throwable) {
                    InstabugSDKLogger.d((Object)((Object)this), (String)("uploading crash logs got error: " + throwable.getMessage()));
                    this.a.onFailed((Object)this.b);
                }

                public final /* synthetic */ void onNext(Object object) {
                    RequestResponse requestResponse = (RequestResponse)object;
                    object = this;
                    InstabugSDKLogger.v((Object)object, (String)("uploading crash logs onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
                }
            });
            return;
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.d((Object)this, (String)("uploading crash logs got Json error: " + jSONException.getMessage()));
            callbacks.onFailed((Object)crash);
            return;
        }
    }
}

