/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.network;

import android.content.Context;
import com.instabug.crash.cache.CrashesCacheManager;
import com.instabug.crash.models.Crash;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;
import rx.Observable;
import rx.Subscriber;

public class a {
    private static a a;
    private NetworkManager b = new NetworkManager();

    private a() {
    }

    public static a a() {
        if (a == null) {
            a = new a();
        }
        return a;
    }

    public void a(Context context, Crash crash, final Request.Callbacks<String, Throwable> callbacks) throws JSONException, IOException {
        ArrayList arrayList;
        InstabugSDKLogger.d((Object)this, (String)("Reporting crash with crash message: " + crash.c()));
        Request request = this.b.buildRequest(context, Request.Endpoint.ReportCrash, Request.RequestMethod.Post);
        if (crash.c() != null && crash.c().contains("InstabugSDK-v: ")) {
            request.addRequestBodyParameter("application_token", (Object)"b1a9630002b2cbdfbfecd942744b9018");
        }
        if ((arrayList = crash.e().getStateItems()) != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                InstabugSDKLogger.d((Object)this, (String)("Crash State Key: " + ((State.StateItem)arrayList.get(i)).getKey() + ", Crash State value: " + ((State.StateItem)arrayList.get(i)).getValue()));
                request.addRequestBodyParameter(((State.StateItem)arrayList.get(i)).getKey(), ((State.StateItem)arrayList.get(i)).getValue());
            }
        }
        request.addRequestBodyParameter("title", (Object)crash.c());
        request.addRequestBodyParameter("attachments_count", (Object)crash.d().size());
        request.addRequestBodyParameter("handled", (Object)crash.g());
        this.b.doRequest(request).subscribe((Subscriber)new Subscriber<RequestResponse>(){

            public void onStart() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"reportingCrashRequest started");
            }

            public void onCompleted() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"reportingCrashRequest completed");
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.d((Object)((Object)this), (String)("reportingCrashRequest got error: " + throwable.getMessage()));
                callbacks.onFailed((Object)throwable);
            }

            public void a(RequestResponse requestResponse) {
                InstabugSDKLogger.v((Object)((Object)this), (String)("reportingCrashRequest onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
                try {
                    callbacks.onSucceeded((Object)new JSONObject((String)requestResponse.getResponseBody()).getString("id"));
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((RequestResponse)object);
            }
        });
    }

    public void b(Context context, final Crash crash, final Request.Callbacks<Boolean, Crash> callbacks) throws JSONException, FileNotFoundException {
        InstabugSDKLogger.d((Object)this, (String)"Uploading Crash attachments");
        Observable[] observableArray = new Observable[crash.d().size()];
        for (int i = 0; i < observableArray.length; ++i) {
            Attachment attachment = crash.d().get(i);
            Request request = this.b.buildRequest(context, Request.Endpoint.AddCrashAttachment, Request.RequestMethod.Post, NetworkManager.RequestType.MULTI_PART);
            request.setEndpoint(request.getEndpoint().replaceAll(":crash_token", crash.b()));
            request.addParameter("metadata[file_type]", (Object)attachment.getType());
            if (attachment.getType() == Attachment.Type.AUDIO) {
                request.addParameter("metadata[duration]", (Object)attachment.getDuration());
            }
            request.setFileToUpload(new Request.FileToUpload("file", attachment.getName(), attachment.getLocalPath(), attachment.getFileType()));
            observableArray[i] = this.b.doRequest(request);
        }
        Observable.merge((Observable[])observableArray, (int)1).subscribe((Subscriber)new Subscriber<RequestResponse>(){

            public void onStart() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"uploadingCrashAttachmentRequest started");
            }

            public void onCompleted() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"uploadingCrashAttachmentRequest completed");
                if (crash.d().size() == 0) {
                    callbacks.onSucceeded((Object)true);
                }
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.d((Object)((Object)this), (String)("uploadingCrashAttachmentRequest got error: " + throwable.getMessage()));
                callbacks.onFailed((Object)crash);
            }

            public void a(RequestResponse requestResponse) {
                InstabugSDKLogger.v((Object)((Object)this), (String)("uploadingCrashAttachmentRequest onNext, Response code: " + requestResponse.getResponseCode() + ", Response body: " + requestResponse.getResponseBody()));
                File file = new File(crash.d().get(0).getLocalPath());
                boolean bl = file.delete();
                Attachment attachment = crash.d().remove(0);
                if (!bl) {
                    InstabugSDKLogger.e((Object)((Object)this), (String)("Attachment: " + attachment + " is not removed"));
                } else {
                    InstabugSDKLogger.d((Object)((Object)this), (String)("Attachment: " + attachment + " is removed"));
                }
                CrashesCacheManager.addCrash(crash);
                CrashesCacheManager.saveCacheToDisk();
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((RequestResponse)object);
            }
        });
    }

    public void c(Context context, final Crash crash, final Request.Callbacks<Boolean, Crash> callbacks) {
        try {
            Request request = this.b.buildRequest(context, Request.Endpoint.crashLogs, Request.RequestMethod.Post);
            request.setEndpoint(request.getEndpoint().replaceAll(":crash_token", crash.b()));
            ArrayList arrayList = crash.e().getLogsItems();
            if (arrayList != null && arrayList.size() > 0) {
                for (State.StateItem stateItem : arrayList) {
                    request.addRequestBodyParameter(stateItem.getKey(), stateItem.getValue());
                }
            }
            this.b.doRequest(request).subscribe((Subscriber)new Subscriber<RequestResponse>(){

                public void onStart() {
                    InstabugSDKLogger.d((Object)((Object)this), (String)"uploading crash logs started");
                }

                public void a(RequestResponse requestResponse) {
                    InstabugSDKLogger.v((Object)((Object)this), (String)("uploading crash logs onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
                }

                public void onCompleted() {
                    InstabugSDKLogger.d((Object)((Object)this), (String)"uploading crash logs completed");
                    callbacks.onSucceeded((Object)true);
                }

                public void onError(Throwable throwable) {
                    InstabugSDKLogger.d((Object)((Object)this), (String)("uploading crash logs got error: " + throwable.getMessage()));
                    callbacks.onFailed((Object)crash);
                }

                public /* synthetic */ void onNext(Object object) {
                    this.a((RequestResponse)object);
                }
            });
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.d((Object)this, (String)("uploading crash logs got Json error: " + jSONException.getMessage()));
            callbacks.onFailed((Object)crash);
        }
    }
}

