package com.instabug.crash.configurations

import com.instabug.commons.preferences.PrefSpecs.ReproAttachmentsAvailability
import com.instabug.commons.preferences.crashPref
import com.instabug.crash.utils.CrashReportingUtility
import com.instabug.library.IBGFeature
import com.instabug.library.core.InstabugCore
import com.instabug.library.visualusersteps.ReproConfigurationsProvider
import com.instabug.library.visualusersteps.ReproProxyAuthID

interface NonFatalsConfigurationProvider: ReproConfigurationsProvider {

}
class NonFatalsConfigurationProviderImpl: NonFatalsConfigurationProvider {

    override var isReproScreenShotsEnabledSDK: Boolean = true

    override var isReproStepsEnabledSDK: Boolean = true
    override val reproProxyAuthId: Int
        get() = ReproProxyAuthID.NonFatals
    override val isReproStepsEnabled: Boolean
        get() = isReproStepsEnabledSDK && CrashReportingUtility.isNonFatalReportingEnabled()

    override val isReproScreenshotsEnabled: Boolean
        get() = isReproScreenShotsEnabledSDK && isReproFeaturesAvailable && isReproScreenshotsAvailable
                && CrashReportingUtility.isNonFatalReportingEnabled()

    private val isReproFeaturesAvailable: Boolean
        get() = InstabugCore.isFeatureAvailable(IBGFeature.REPRO_STEPS)

    override var isReproScreenshotsAvailable: Boolean = true
        get() = CrashReportingUtility.isReproScreenshotsAvailable()}