package com.instabug.crash

object Constants {

    const val LOG_TAG = "IBG-CR"

    const val CORE_SP_FILE_NAME = "instabug"

    const val FEATURE_NAME = "Crashes"

    const val FINGERPRINT_LIMIT_WARNING =
        "Grouping string exceeds the defined maximum characters limit (40) so it will be trimmed"
    const val FINGERPRINT_EMPTY_ERROR =
        "Grouping string not provided. This crash will be grouped by the default grouping algorithm."
    const val EARLY_ANR_EXIT_INFO_COUNT = 5
    const val IGNORE_NON_FATAL = "ignored_non_fatals"

    object Preferences {
        val CRASH_REPORTING_AVAILABILITY: Pair<String, Boolean> =
            ("crash_reporting_availability" to true)
        val IS_CRASH_REPORTING_MIGRATED: Pair<String, Boolean> =
            ("is_crash_reporting_migrated" to false)
        val ANR_AVAILABILITY: Pair<String, Boolean> =
            ("anr_availability" to BuildConfig.CAPTURE_EARLY_ANRS)
        val FATAL_HANGS_AVAILABILITY: Pair<String, Boolean> = ("fatal_hangs_availability" to false)
        val FATAL_HANGS_SENSITIVITY: Pair<String, Long> = ("fatal_hangs_sensitivity" to 2000)
        val IS_ANR_MIGRATED: Pair<String, Boolean> = ("is_anr_migrated" to false)
        val IS_FATAL_HANGS_MIGRATED: Pair<String, Boolean> = ("is_fatal_hangs_migrated" to false)
        val IS_TERMINATIONS_MIGRATED: Pair<String, Boolean> = ("is_terminations_migrated" to false)
        val TERMINATIONS_AVAILABILITY: Pair<String, Boolean> =
            ("terminations_availability" to false)
        val TERMINATIONS_THRESHOLD: Pair<String, Long> = ("terminations_threshold" to 30_000L)
        val TERMINATIONS_STATE_RATIO: Pair<String, Float> = ("terminations_state_ratio" to 0.3f)
        val CRASH_METADATA_CALLBACK_ENABLED = "is_crash_metadata_callback_enabled" to false
        val NON_FATAL_AVAILABILITY = "is_non_fatal_enabled" to true
        val METADATA_IMMEDIATE_SYNC_AVAILABILITY = "is_metadata_immediate_sync_enabled" to false
        val LAST_EARLY_ANR_MIGRATION_MILLS = "last_early_anr_migration_time" to 0L
        val ANR_V2_AVAILABLE = "is_anr_v2_available" to BuildConfig.CAPTURE_EARLY_ANRS
    }
}