package com.instabug.commons.diagnostics.di

import com.instabug.commons.configurations.ConfigurationsHandler
import com.instabug.commons.diagnostics.configurations.DefaultDiagnosticsConfigProvider
import com.instabug.commons.diagnostics.configurations.DiagnosticsConfigProvider
import com.instabug.commons.diagnostics.configurations.DiagnosticsConfigurationsHandler
import com.instabug.commons.diagnostics.event.CalibrationDiagnosticEvent
import com.instabug.commons.diagnostics.reporter.DefaultDiagnosticsReporter
import com.instabug.commons.diagnostics.reporter.DiagnosticsReporter

object DiagnosticsLocator {
    @JvmStatic
    val reporter: DiagnosticsReporter by lazy { DefaultDiagnosticsReporter() }

    @JvmStatic
    val configProvider: DiagnosticsConfigProvider by lazy { DefaultDiagnosticsConfigProvider() }

    @JvmStatic
    val configHandler: ConfigurationsHandler by lazy { DiagnosticsConfigurationsHandler() }

    @JvmStatic
    var ndkIncidentTypeGetter: () -> CalibrationDiagnosticEvent.IncidentType = {
        object : CalibrationDiagnosticEvent.IncidentType {
            override val diagnosticsName: String = "ndk"
            override val reportingPredicate: () -> Boolean = { true }
        }
    }
}
