package com.instabug.bganr

import android.content.Context
import android.os.Build
import androidx.annotation.RequiresApi
import androidx.annotation.VisibleForTesting
import com.instabug.anr.configuration.AnrConfigurationProvider
import com.instabug.anr.di.AnrServiceLocator
import com.instabug.anr.network.InstabugAnrUploaderJob
import com.instabug.commons.DefaultOSExitInfoExtractor
import com.instabug.commons.OSExitInfoExtractor
import com.instabug.commons.caching.FileCacheDirectory
import com.instabug.commons.caching.SessionCacheDirectory
import com.instabug.commons.configurations.ConfigurationsHandler
import com.instabug.commons.di.CommonsLocator
import com.instabug.commons.session.SessionLinker
import com.instabug.commons.snapshot.CaptorsRegistry
import com.instabug.crash.configurations.CrashConfigurationProvider
import com.instabug.crash.di.CrashesServiceLocator
import com.instabug.library.Instabug
import com.instabug.library.InstabugNetworkJob
import com.instabug.library.WatchableSpansCacheDirectory
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.logscollection.DataWatcher

private typealias Provider = BackgroundAnrConfigurationsProvider
private typealias Handler = BackgroundAnrConfigurationsHandler

object BackgroundAnrLocator {
    val crashesCacheDir: SessionCacheDirectory
        get() = CommonsLocator.crashesCacheDir

    val backgroundAnrCacheDir: FileCacheDirectory
            by lazy { BackgroundAnrCacheDir(crashesCacheDir) }

    val captorsRegistry: CaptorsRegistry
        get() = CommonsLocator.captorsRegistry

    @VisibleForTesting
    val crashConfigurationsProvider: CrashConfigurationProvider
        get() = CrashesServiceLocator.crashConfigurationProvider

    @VisibleForTesting
    val anrConfigurationsProvider: AnrConfigurationProvider
        get() = AnrServiceLocator.anrConfigurationProvider

    val configurationsProvider: IBackgroundAnrConfigurationsProvider
            by lazy { Provider(crashConfigurationsProvider, anrConfigurationsProvider) }

    val configurationsHandler: ConfigurationsHandler
            by lazy { Handler(configurationsProvider) }

    val syncJob: InstabugNetworkJob
        get() = InstabugAnrUploaderJob.getInstance()

    val migrator: IBackgroundAnrMigrator
        @RequiresApi(Build.VERSION_CODES.R)
        get() = BackgroundAnrMigrator(
            crashesCacheDir, exitInfoExtractor, reproScreenshotsCacheDir,
            configurationsProvider
        )

    val appCtx: Context?
        get() = Instabug.getApplicationContext()

    val sessionLinker: SessionLinker
        get() = CommonsLocator.sessionLinker

    val exitInfoExtractor: OSExitInfoExtractor
        @RequiresApi(Build.VERSION_CODES.R)
        get() = DefaultOSExitInfoExtractor()

    val reproScreenshotsCacheDir: WatchableSpansCacheDirectory
        get() = CoreServiceLocator.reproScreenshotsCacheDir

    val hubDataWatcher: DataWatcher
        get() = CoreServiceLocator.hubDataWatcher
}
