package com.instabug.anr.configuration

import com.instabug.commons.preferences.crashPref
import com.instabug.crash.Constants
import com.instabug.crash.utils.CrashReportingUtility
import com.instabug.library.IBGFeature
import com.instabug.library.core.InstabugCore
import com.instabug.library.visualusersteps.ReproProxyAuthID

class AnrConfigurationProviderImpl : AnrConfigurationProvider {

    override var anrLocallyEnabled: Boolean = true
    override var isAnrAvailable: Boolean by crashPref(Constants.Preferences.ANR_AVAILABILITY)
    override var lastEarlyAnrMigrationMillis: Long by crashPref(Constants.Preferences.LAST_EARLY_ANR_MIGRATION_MILLS)
    override var isAnrV2Available: Boolean by crashPref(Constants.Preferences.ANR_V2_AVAILABLE)
    override val isAnrV2Enabled: Boolean
        get() = isAnrV2Available && isAnrEnabled()

    override fun isAnrEnabled(): Boolean {
        return CrashReportingUtility.isCrashReportingEnabled() and anrLocallyEnabled and isAnrAvailable
    }

    override var isReproScreenShotsEnabledSDK: Boolean = true

    override var isReproStepsEnabledSDK: Boolean = true

    override val reproProxyAuthId: Int
        get() = ReproProxyAuthID.ANR

    override val isReproStepsEnabled: Boolean
        get() = isReproStepsEnabledSDK && isAnrEnabled()

    override val isReproScreenshotsEnabled: Boolean
        get() = isReproScreenShotsEnabledSDK && isReproScreenshotsAvailable && isReproFeaturesAvailable && isAnrEnabled()

    private val isReproFeaturesAvailable: Boolean
        get() = InstabugCore.isFeatureAvailable(IBGFeature.REPRO_STEPS)

    override var isReproScreenshotsAvailable: Boolean = true
        get() = CrashReportingUtility.isReproScreenshotsAvailable()}
