package com.instabug.terminations.cache

import android.content.Context
import com.instabug.terminations.model.Termination

interface TerminationsCachingManager {
    fun insertAndTrim(context: Context, termination: Termination)
    fun update(termination: Termination): Int
    fun delete(context: Context, termination: Termination): Int
    fun clear(context: Context)
    fun retrieve(context: Context): List<Termination>
}