package com.instabug.fatalhangs.cache

import android.content.Context
import androidx.annotation.WorkerThread
import com.instabug.fatalhangs.model.FatalHang

@WorkerThread
interface FatalHangsCacheManager {
    fun insert(fatalHang: FatalHang, context: Context?)
    fun update(fatalHang: FatalHang)
    fun delete(id: String)
    fun retrieveFirst(context: Context): FatalHang?
    fun deleteAll(context: Context?)
}