package com.instabug.early_crash.configurations

import com.instabug.commons.configurations.ConfigurationsHandler
import com.instabug.commons.logging.runOrReportError
import com.instabug.crash.BuildConfig
import org.json.JSONObject

private const val BE_KEY_EARLY_CRASH_AVAILABILITY = "an_crash_early_capture"

class EarlyCrashesConfigHandler(
    private val configProvider: IEarlyCrashesConfigProvider
) : ConfigurationsHandler {
    override fun handleConfiguration(configuration: String?) {
        runCatching {
            configuration?.let(::JSONObject)
                ?.optBoolean(BE_KEY_EARLY_CRASH_AVAILABILITY, BuildConfig.CAPTURE_EARLY_CRASHES)
                ?.also(configProvider::setEarlyCrashesAvailable)
        }.runOrReportError("Error while parsing early crashes config")
    }

    override fun migrateCurrentConfiguration() {
        // No-Op
    }

}