package com.instabug.crash.settings;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;

import androidx.annotation.Nullable;

import com.instabug.commons.preferences.CrashPrefPropertyKt;
import com.instabug.library.Instabug;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;

/**
 * @author tarek
 */
public class PersistableSettings {

    private static final String IB_LAST_CRASH_TIME = "last_crash_time";
    private static final String IB_LAST_Crash_REQUEST_STARTED_AT = "last_crash_request_started_at";
    private static final String IB_CRASHES_LIMITED_UNTIL = "crashes_rate_limited_until";
    private static final String IB_IS_FIRST_RUN_AFTER_ENCRYPTOR_UPDATE = "ib_first_run_after_updating_encryptor";

    @Nullable
    private SharedPreferences sharedPreferences;
    private static PersistableSettings persistableSettings;

    private PersistableSettings() {
        sharedPreferences = CrashPrefPropertyKt.getCrashesPreferences();
    }

    public static void init() {
        persistableSettings = new PersistableSettings();
    }

    public static PersistableSettings getInstance() {
        if (persistableSettings == null && Instabug.getApplicationContext() != null) {
            init();
        }
        return persistableSettings;
    }

    public void setLastCrashTime(long time) {
        if (sharedPreferences == null) return;
        sharedPreferences.edit().putLong(IB_LAST_CRASH_TIME, time).apply();
    }

    public long getLastCrashTime() {
        if (sharedPreferences == null) return 0;
        return sharedPreferences.getLong(IB_LAST_CRASH_TIME, 0L);
    }

    @SuppressLint("ERADICATE_FIELD_NOT_NULLABLE")
    public static void release() {
        persistableSettings = null;
    }

    public boolean isFirstRunAfterEncryptorUpdate() {
        // Defaults to true if not set before
        if (sharedPreferences == null) return true;
        return sharedPreferences.getBoolean(IB_IS_FIRST_RUN_AFTER_ENCRYPTOR_UPDATE, true);
    }

    public void setFirstRunAfterEncryptorUpdate(boolean isFirstRun) {
        if (sharedPreferences == null) return;
        sharedPreferences.edit().putBoolean(IB_IS_FIRST_RUN_AFTER_ENCRYPTOR_UPDATE, isFirstRun).apply();
    }

    public void setLastCrashRequestStartedAt(long time) {
        if (sharedPreferences == null) return;
        sharedPreferences.edit().putLong(IB_LAST_Crash_REQUEST_STARTED_AT, time).apply();
    }

    public long getLastCrashRequestStartedAt() {
        return (sharedPreferences == null)
                ? 0L
                : sharedPreferences.getLong(IB_LAST_Crash_REQUEST_STARTED_AT, 0L);
    }

    public void setCrashesLimitedUntil(int period) {
        if (sharedPreferences == null) return;
        long limitedUntilTime = getLastCrashRequestStartedAt() + period * 1000L;
        sharedPreferences.edit().putLong(IB_CRASHES_LIMITED_UNTIL, limitedUntilTime).apply();
    }

    public long getCrashesLimitedUntil() {
        return (sharedPreferences == null)
                ? 0L
                : sharedPreferences.getLong(IB_CRASHES_LIMITED_UNTIL, 0L);
    }
}