package com.instabug.crash.screenrecording;

import android.net.Uri;

import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.internal.video.ScreenRecordingContract;

import androidx.annotation.Nullable;


public class ExternalAutoScreenRecordHelper implements ScreenRecordingContract {

    private static ExternalAutoScreenRecordHelper INSTANCE;

    public static ExternalAutoScreenRecordHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExternalAutoScreenRecordHelper();
        }

        return INSTANCE;
    }

    private ExternalAutoScreenRecordHelper() {
    }

    @Override
    @Nullable
    public Uri getAutoScreenRecordingFileUri() {
        return InternalAutoScreenRecorderHelper.getInstance().getAutoScreenRecordingFileUri();
    }

    @Override
    public void delete() {
        InternalAutoScreenRecorderHelper.getInstance().delete();
    }

    @Override
    public void clear() {
        InternalAutoScreenRecorderHelper.getInstance().clear();
    }

    @Override
    public boolean isEnabled() {
        return InternalAutoScreenRecorderHelper.getInstance().isEnabled();
    }

    public void start() {
        InternalAutoScreenRecorderHelper.getInstance().start();
    }
}
