package com.instabug.crash.nonFatals.ignorenonfatalsvalidation

import com.instabug.crash.Constants
import com.instabug.crash.models.IgnoredNonFatal
import com.instabug.crash.nonFatals.ignorenonfatalsvalidation.NonFatalMessageRegexValidator.matchIgnoreNonFatalRegexWithActualMessage
import com.instabug.library.Instabug.getApplicationContext
import com.instabug.library.util.DeviceStateProvider
import com.instabug.library.util.InstabugSDKLogger
import org.json.JSONObject

const val MAX_FINGERPRINT_LENGTH = 40
private const val KEY_ERROR = "error"
fun IgnoredNonFatal.validateMessageWithEmRegex(jsonObject: JSONObject): Boolean {
    return runCatching {
        val errorObject = jsonObject.optJSONObject(KEY_ERROR)
        val message = errorObject?.optString("message").orEmpty().ifEmpty {
            jsonObject.optString("e_message")
        }
        return this.emRegex.takeIf { !it.isNullOrEmpty() }?.let { emRegex ->
            matchIgnoreNonFatalRegexWithActualMessage(
                emRegex,
                message
            )
        } ?: true
    }.getOrElse {
        InstabugSDKLogger.e(
            Constants.LOG_TAG,
            "something went wrong while extracting message: ${it.message}"
        )
        false
    }
}

fun IgnoredNonFatal.validateExceptionName(jsonObject: JSONObject): Boolean {
    return runCatching {
        val errorObject = jsonObject.optJSONObject(KEY_ERROR)
        val exceptionName = errorObject?.optString("name").orEmpty().ifEmpty {
            jsonObject.optString("e_name")
        }
        return this.en.takeIf { !it.isNullOrEmpty() }?.let { en -> en == exceptionName } ?: true
    }.getOrElse {
        InstabugSDKLogger.e(Constants.LOG_TAG, "something went wrong while extracting exception name: ${it.message}")
        false
    }
}

fun IgnoredNonFatal.validateAppVersion(): Boolean {
    val appVersion = DeviceStateProvider.getAppVersion(getApplicationContext())
    return this.appVersions?.takeIf { it.isNotEmpty() }?.any { it == appVersion } ?: true
}

fun IgnoredNonFatal.validateFingerPrint(fingerPrint: JSONObject?): Boolean {
    val fingerPrintLength = fingerPrint?.optInt("length")
    val originalFingerPrint = fingerPrint?.optString("original")
    if (gs.isNullOrEmpty()) {
        return true
    }
    return fingerPrintLength?.let {
        if (fingerPrintLength < MAX_FINGERPRINT_LENGTH) {
            this.gs?.let { gsValue -> gsValue == originalFingerPrint } ?: false
        } else {
            this.gs?.let { gsValue -> originalFingerPrint?.contains(gsValue) == true } ?: false
        }
    } ?: false
}

fun IgnoredNonFatal.hasValidData(): Boolean {
    return !gs.isNullOrBlank() ||
        !en.isNullOrBlank() ||
        !emRegex.isNullOrBlank() ||
        (appVersions?.any { it.isNotBlank() } == true)
}
