package com.instabug.crash.configurations.utilities

import com.instabug.crash.Constants
import com.instabug.crash.Constants.IGNORE_NON_FATAL
import com.instabug.crash.configurations.CrashConfigurationHandlerImpl.Companion.CRASHES_KEY
import com.instabug.crash.models.IgnoredNonFatal
import com.instabug.library.util.InstabugSDKLogger
import org.json.JSONObject

fun handleIgnoreNonFatalJsonResponse(configuration: String): List<IgnoredNonFatal>? {
    return try {
        val jsonObject = JSONObject(configuration)
        val crashesObject = jsonObject.optJSONObject(CRASHES_KEY)
        val ignoredNonFatalArray = crashesObject?.optJSONArray(IGNORE_NON_FATAL)
        val ignoredNonFatalList = mutableListOf<IgnoredNonFatal>()
        if (ignoredNonFatalArray != null) {
            for (i in 0 until ignoredNonFatalArray.length()) {
                val ignoredNonFatalJson = ignoredNonFatalArray.optJSONObject(i)
                if (ignoredNonFatalJson != null) {
                    val ignoredNonFatal = IgnoredNonFatal().apply {
                        fromJson(ignoredNonFatalJson.toString())
                    }
                    ignoredNonFatalList.add(ignoredNonFatal)
                }
            }
        }
        ignoredNonFatalList
    } catch (exception: Exception) {
        InstabugSDKLogger.e(
            Constants.LOG_TAG,
            "something went wrong while parsing ignore non fatals response" + exception.message
        )
        null
    }
}
