package com.instabug.commons.session

import com.instabug.commons.di.CommonsLocator
import com.instabug.library.model.v3Session.IBGSessionData
import com.instabug.library.sessionV3.providers.FeatureSessionDataController
import com.instabug.library.sessionV3.providers.SessionID

object CrashesSessionsDataController : FeatureSessionDataController {

    private val cacheHandler: SessionIncidentCachingHandler
        get() = CommonsLocator.sessionIncidentCachingHandler

    override fun collectSessionsData(sessionsIds: List<SessionID>): Map<SessionID, IBGSessionData> {
        return cacheHandler
            .queryIncidentsBySessionsIds(sessionsIds)
            .let(::incidentsToSessionsData)
            .let { linkedSessionsMap -> complementSessionsMap(linkedSessionsMap, sessionsIds) }
    }

    override fun dropSessionData(sessionsIds: List<SessionID>) {
        cacheHandler.deleteIncidentsBySessionsIds(sessionsIds)
    }
}