package com.instabug.commons.preferences

import android.content.SharedPreferences
import com.instabug.crash.Constants
import com.instabug.crash.models.IgnoredNonFatal
import com.instabug.library.internal.sharedpreferences.ReadWriteStrategyPreferenceProperty
import com.instabug.library.util.InstabugSDKLogger
import org.json.JSONArray
import org.json.JSONObject

class IgnoredNonFatalListReadWriteStrategy :
    ReadWriteStrategyPreferenceProperty.ReadWriteStrategy<List<IgnoredNonFatal>?> {
    override fun SharedPreferences.get(
        key: String,
        default: List<IgnoredNonFatal>?
    ): List<IgnoredNonFatal>? {
        return runCatching {
            val jsonString = this.getString(key, null)
            if (jsonString != null) {
                val jsonArray = JSONArray(jsonString)
                val list = mutableListOf<IgnoredNonFatal>()
                for (i in 0 until jsonArray.length()) {
                    val jsonObject = jsonArray.getJSONObject(i)
                    val ignoredNonFatal = IgnoredNonFatal().apply {
                        fromJson(jsonObject.toString())
                    }
                    list.add(ignoredNonFatal)
                }
                list
            } else {
                default
            }
        }.getOrElse {
            InstabugSDKLogger.e(
                Constants.LOG_TAG,
                "something went wrong while getting the response from sharedpref" + it.message
            )
            return default
        }
    }

    override fun SharedPreferences.Editor.put(
        key: String,
        value: List<IgnoredNonFatal>?
    ): SharedPreferences.Editor {
        return runCatching {
            if (value == null) {
                this.putString(key, null)
            }
            value?.let {
                val jsonArray = JSONArray()
                for (ignoredNonFatal in value) {
                    jsonArray.put(JSONObject(ignoredNonFatal.toJson()))
                }
                this.putString(key, jsonArray.toString())
            }
            this
        }.getOrElse {
            InstabugSDKLogger.e(
                Constants.LOG_TAG,
                "something went wrong while putting the response from sharedpref" + it.message
            )
            this
        }
    }
}
