package com.instabug.commons.caching

import android.content.Context
import androidx.annotation.WorkerThread
import com.instabug.library.internal.storage.DiskUtils
import com.instabug.library.util.FileUtils
import com.instabug.library.util.extenstions.ifNotExists
import com.instabug.library.visualusersteps.VisualUserStepsHelper
import java.io.File

object DiskHelper {
    @JvmStatic
    fun getCrashesInternalDirectory(ctx: Context) =
        File(DiskUtils.getInstabugInternalDirectory(ctx), "crash-reports")
            .ifNotExists { mkdirs() }
            .also(this::createNoMediaFile)

    private fun createNoMediaFile(parentDir: File) {
        runCatching { File(parentDir, ".nomedia").ifNotExists { createNewFile() } }
    }

    @JvmStatic
    fun getIncidentSavingDirectory(ctx: Context, prefix: String, incidentId: String) =
        File(getCrashesInternalDirectory(ctx), "${prefix}_$incidentId")

    @JvmStatic
    fun getIncidentStateFile(savingDir: File, prefix: String) =
        File(savingDir, "${prefix}_${System.currentTimeMillis()}.txt")

    @JvmStatic
    fun getIncidentStateFileJson(savingDir: File, prefix: String) =
        File(savingDir, "${prefix}_${System.currentTimeMillis()}.json")

    @JvmStatic
    @WorkerThread
    fun getReproScreenshotsZipPath(
        ctx: Context,
        incidentId: String,
        savingDir: File,
        screenshotsDir: File
    ): Pair<String?, Boolean> {
        val temporaryScreenshotsZip =
            VisualUserStepsHelper.getVisualUserStepsFile(ctx, incidentId, screenshotsDir)
        return FileUtils.copyAndDeleteOriginalFile(
            ctx,
            temporaryScreenshotsZip.uri?.path,
            "${savingDir.absolutePath}/"
        ) to temporaryScreenshotsZip.isUriEncrypted
    }
}
