/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.fatalhangs.sync;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.instabug.commons.utils.RateLimiterUtilsKt;
import com.instabug.crash.settings.CrashSettings;
import com.instabug.crash.utils.DeleteCrashUtilsKt;
import com.instabug.fatalhangs.cache.FatalHangsCacheManager;
import com.instabug.fatalhangs.di.FatalHangsServiceLocator;
import com.instabug.fatalhangs.model.FatalHang;
import com.instabug.fatalhangs.sync.FatalHangsRequestsBuilder;
import com.instabug.fatalhangs.sync.FatalHangsSyncManager;
import com.instabug.fatalhangs.sync.FatalHangsSyncManagerImpl;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.operation.DeleteUriDiskOperation;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.model.Attachment;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001f0\u001eH\u0007J\b\u0010 \u001a\u00020\fH\u0002J\b\u0010!\u001a\u00020\fH\u0016J$\u0010\"\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006%"}, d2={"Lcom/instabug/fatalhangs/sync/FatalHangsSyncManagerImpl;", "Lcom/instabug/fatalhangs/sync/FatalHangsSyncManager;", "()V", "fatalHangsCacheManager", "Lcom/instabug/fatalhangs/cache/FatalHangsCacheManager;", "networkManager", "Lcom/instabug/library/networkv2/NetworkManager;", "getNetworkManager", "()Lcom/instabug/library/networkv2/NetworkManager;", "networkManager$delegate", "Lkotlin/Lazy;", "deleteFataHangAndStateFile", "", "context", "Landroid/content/Context;", "fatalHang", "Lcom/instabug/fatalhangs/model/FatalHang;", "deleteFatalHang", "handleRateIsLimited", "handleRateLimitException", "exception", "Lcom/instabug/library/networkv2/RateLimitedException;", "handleSuccessfulRequest", "id", "", "logRateIsLimited", "sendFatalHangAttachments", "sendFatalHangLogs", "sendFatalHangRequest", "callback", "Lcom/instabug/library/networkv2/request/Request$Callbacks;", "", "startFatalHangsSync", "syncFatalHangs", "uploadFatalHangAttachments", "fatalHangAttachmentsCallbacks", "", "instabug-crash_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nFatalHangsSyncManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FatalHangsSyncManagerImpl.kt\ncom/instabug/fatalhangs/sync/FatalHangsSyncManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n1#2:318\n1855#3,2:319\n*S KotlinDebug\n*F\n+ 1 FatalHangsSyncManagerImpl.kt\ncom/instabug/fatalhangs/sync/FatalHangsSyncManagerImpl\n*L\n269#1:319,2\n*E\n"})
public final class FatalHangsSyncManagerImpl
implements FatalHangsSyncManager {
    @NotNull
    private final Lazy networkManager$delegate = LazyKt.lazy((Function0)networkManager.2.INSTANCE);
    @NotNull
    private final FatalHangsCacheManager fatalHangsCacheManager = FatalHangsServiceLocator.INSTANCE.getFatalHangsCacheManager();

    private final NetworkManager getNetworkManager() {
        return (NetworkManager)this.networkManager$delegate.getValue();
    }

    private final void startFatalHangsSync() {
        Context context = FatalHangsServiceLocator.INSTANCE.getContext();
        if (context != null) {
            Ref.ObjectRef objectRef;
            Ref.ObjectRef objectRef2 = objectRef;
            objectRef = new Ref.ObjectRef();
            FatalHang fatalHang = this.fatalHangsCacheManager.retrieveFirst(context);
            objectRef2.element = fatalHang;
            if (fatalHang != null) {
                int n = fatalHang.getFatalHangState();
                if (n != 1) {
                    if (n != 2) {
                        if (n == 3) {
                            this.sendFatalHangAttachments(fatalHang);
                        }
                    } else {
                        this.sendFatalHangLogs(fatalHang);
                    }
                } else {
                    Request.Callbacks<String, Throwable> callbacks2;
                    Request.Callbacks<String, Throwable> callbacks3 = callbacks2;
                    callbacks2 = new Request.Callbacks<String, Throwable>(this, fatalHang, context, (Ref.ObjectRef<FatalHang>)objectRef2){
                        final /* synthetic */ FatalHangsSyncManagerImpl this$0;
                        final /* synthetic */ FatalHang $it;
                        final /* synthetic */ Context $context;
                        final /* synthetic */ Ref.ObjectRef<FatalHang> $fatalHang;
                        {
                            void var4_4;
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            this.this$0 = var1_1;
                            this.$it = var2_2;
                            this.$context = var3_3;
                            this.$fatalHang = var4_4;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void onSucceeded(@NotNull String id) {
                            void var1_1;
                            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"id");
                            startFatalHangsSync.1.1.1 v0 = this_;
                            FatalHang this_ = v0.$it;
                            Context context = v0.$context;
                            FatalHangsSyncManagerImpl.access$handleSuccessfulRequest(this_.this$0, this_, (String)var1_1, context);
                        }

                        public void onFailed(@NotNull Throwable error) {
                            FatalHang fatalHang;
                            Throwable throwable = error;
                            Intrinsics.checkNotNullParameter((Object)throwable, (String)"error");
                            if (throwable instanceof RateLimitedException) {
                                void v1 = fatalHang;
                                fatalHang = this.$it;
                                FatalHangsSyncManagerImpl.access$handleRateLimitException(this.this$0, fatalHang, (RateLimitedException)v1);
                            } else {
                                InstabugSDKLogger.e((String)"IBG-CR", (String)"Failed to send fatal hang", (Throwable)((Object)fatalHang));
                            }
                            this.$fatalHang.element = null;
                        }
                    };
                    this.sendFatalHangRequest(fatalHang, callbacks3);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleSuccessfulRequest(FatalHang fatalHang, String id, Context context) {
        void var1_1;
        CrashSettings.getInstance().setLastRequestStartedAt(0L);
        if (RateLimiterUtilsKt.hasRateLimitedPrefix(id)) {
            void var3_3;
            this.deleteFatalHang((Context)var3_3, (FatalHang)var1_1);
        } else {
            void var2_2;
            void v0 = var1_1;
            v0.setTemporaryServerToken((String)var2_2);
            v0.setFatalHangState(2);
            this.fatalHangsCacheManager.update((FatalHang)var1_1);
            this.sendFatalHangLogs((FatalHang)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendFatalHangLogs(FatalHang fatalHang) {
        Request.Callbacks<RequestResponse, Throwable> callbacks2;
        void var1_1;
        Request request = FatalHangsRequestsBuilder.INSTANCE.buildFatalHangLogsRequest((FatalHang)var1_1);
        Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>((FatalHang)var1_1, this){
            final /* synthetic */ FatalHang $fatalHang;
            final /* synthetic */ FatalHangsSyncManagerImpl this$0;
            {
                void var2_2;
                void var1_1;
                this.$fatalHang = var1_1;
                this.this$0 = var2_2;
            }

            public void onSucceeded(@Nullable RequestResponse response) {
                sendFatalHangLogs.1 v0 = this;
                v0.$fatalHang.setFatalHangState(3);
                FatalHangsSyncManagerImpl.access$getFatalHangsCacheManager$p(v0.this$0).update(this.$fatalHang);
                FatalHangsSyncManagerImpl.access$sendFatalHangAttachments(v0.this$0, this.$fatalHang);
            }

            /*
             * WARNING - void declaration
             */
            public void onFailed(@NotNull Throwable error) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                InstabugSDKLogger.e((String)"IBG-CR", (String)"Failed to send Fatal hang logs request", (Throwable)var1_1);
            }
        };
        this.getNetworkManager().doRequestOnSameThread(1, request, (Request.Callbacks)callbacks3);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendFatalHangAttachments(FatalHang fatalHang) {
        void var1_1;
        Request.Callbacks<Boolean, Throwable> callbacks2;
        Request.Callbacks<Boolean, Throwable> callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<Boolean, Throwable>(this, (FatalHang)var1_1){
            final /* synthetic */ FatalHangsSyncManagerImpl this$0;
            final /* synthetic */ FatalHang $fatalHang;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$fatalHang = var2_2;
            }

            public void onSucceeded(@Nullable Boolean response) {
                InstabugSDKLogger.d((String)"IBG-CR", (String)"Fatal hang attachments uploaded successfully");
                Context context = FatalHangsServiceLocator.INSTANCE.getContext();
                if (context != null) {
                    FatalHangsSyncManagerImpl.access$deleteFatalHang(this.this$0, context, this.$fatalHang);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onFailed(@NotNull Throwable error) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"error");
                AttachmentsUtility.encryptAttachmentsAndUpdateDb(this.$fatalHang.getAttachments());
                InstabugSDKLogger.e((String)"IBG-CR", (String)"Something went wrong while uploading fatal hang attachments", (Throwable)var1_1);
            }
        };
        this.uploadFatalHangAttachments((FatalHang)var1_1, callbacks3);
    }

    /*
     * WARNING - void declaration
     */
    private final void uploadFatalHangAttachments(FatalHang fatalHang, Request.Callbacks<Boolean, Throwable> fatalHangAttachmentsCallbacks) {
        ArrayList<Attachment> arrayList;
        void var2_2;
        void var1_1;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("Uploading Fatal hang attachments, size: " + var1_1.getAttachments().size()));
        if (fatalHang.getAttachments().size() == 0) {
            var2_2.onSucceeded((Object)Boolean.TRUE);
            return;
        }
        ArrayList<Attachment> arrayList2 = arrayList;
        arrayList = new ArrayList<Attachment>();
        int n = var1_1.getAttachments().size();
        for (int i = 0; i < n; ++i) {
            Attachment attachment = var1_1.getAttachments().get(i);
            if (AttachmentsUtility.decryptAttachmentAndUpdateDb((Attachment)attachment)) {
                Object object;
                Request request = FatalHangsRequestsBuilder.INSTANCE.buildSingleAttachmentRequest((FatalHang)var1_1, attachment);
                if (request == null || (object = attachment.getLocalPath()) == null) continue;
                String string = object;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                object = FatalHangsServiceLocator.INSTANCE.getFileFromPath(string);
                if (((File)object).exists() && ((File)object).length() > 0L) {
                    Request.Callbacks<RequestResponse, Throwable> callbacks2;
                    attachment.setAttachmentState(Attachment.AttachmentState.SYNCED);
                    object = callbacks2;
                    callbacks2 = new Request.Callbacks<RequestResponse, Throwable>(attachment, arrayList2, (FatalHang)var1_1, (Request.Callbacks<Boolean, Throwable>)var2_2){
                        final /* synthetic */ Attachment $attachment;
                        final /* synthetic */ List<Attachment> $synced;
                        final /* synthetic */ FatalHang $fatalHang;
                        final /* synthetic */ Request.Callbacks<Boolean, Throwable> $fatalHangAttachmentsCallbacks;
                        {
                            void var4_4;
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            this.$attachment = var1_1;
                            this.$synced = var2_2;
                            this.$fatalHang = var3_3;
                            this.$fatalHangAttachmentsCallbacks = var4_4;
                        }

                        public void onSucceeded(@NotNull RequestResponse requestResponse) {
                            Attachment attachment;
                            Intrinsics.checkNotNullParameter((Object)attachment, (String)"requestResponse");
                            InstabugSDKLogger.v((String)"IBG-CR", (String)("uploadingFatalHangAttachmentRequest Succeeded, Response code: " + attachment.getResponseCode() + ", Response body: " + attachment.getResponseBody()));
                            if (this.$attachment.getLocalPath() != null) {
                                uploadFatalHangAttachments.1.1.1 v0 = this;
                                attachment = v0.$attachment;
                                FatalHang fatalHang = v0.$fatalHang;
                                List<Attachment> list = v0.$synced;
                                Attachment attachment2 = attachment;
                                DeleteCrashUtilsKt.deleteAttachment(attachment2, fatalHang.getId());
                                list.add(attachment2);
                            }
                            if (this.$synced.size() == this.$fatalHang.getAttachments().size()) {
                                this.$fatalHangAttachmentsCallbacks.onSucceeded((Object)Boolean.TRUE);
                            }
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void onFailed(@NotNull Throwable error) {
                            void var1_1;
                            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"error");
                            InstabugSDKLogger.d((String)"IBG-CR", (String)("uploadingFatalHangAttachmentRequest got error: " + var1_1.getMessage()));
                            this.$fatalHangAttachmentsCallbacks.onFailed((Object)var1_1);
                        }
                    };
                    this.getNetworkManager().doRequestOnSameThread(2, request, (Request.Callbacks)object);
                    continue;
                }
                InstabugSDKLogger.w((String)"IBG-CR", (String)("Skipping attachment file of type " + attachment.getType() + " because it's either not found or empty file"));
                continue;
            }
            InstabugSDKLogger.w((String)"IBG-CR", (String)("Skipping attachment file of type " + attachment.getType() + " because it was not decrypted successfully"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRateIsLimited(FatalHang fatalHang) {
        this.logRateIsLimited();
        Context context = FatalHangsServiceLocator.INSTANCE.getContext();
        if (context != null) {
            void var1_1;
            this.deleteFatalHang(context, (FatalHang)var1_1);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void deleteFatalHang(Context context, FatalHang fatalHang) {
        Object object;
        void var2_2;
        block9: {
            Throwable throwable2;
            block8: {
                FatalHang fatalHang2;
                try {
                    fatalHang2 = fatalHang;
                }
                catch (Throwable throwable2) {
                    break block8;
                }
                Iterator iterator = fatalHang2.getAttachments().iterator();
                while (iterator.hasNext()) {
                    DeleteCrashUtilsKt.deleteAttachment((Attachment)iterator.next(), var2_2.getId());
                }
                {
                    void var1_1;
                    super.deleteFataHangAndStateFile((Context)var1_1, (FatalHang)var2_2);
                    object = var2_2.getSavingDirOnDisk((Context)var1_1);
                }
                {
                    if (!((File)object).exists()) {
                        object = null;
                    }
                    object = object != null ? Boolean.valueOf(FilesKt.deleteRecursively((File)object)) : null;
                    object = Result.constructor-impl((Object)object);
                    break block9;
                }
            }
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
        }
        object = Result.exceptionOrNull-impl((Object)object);
        if (object != null) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)("couldn't delete fatal hang " + var2_2.getId()), (Throwable)object);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void deleteFataHangAndStateFile(Context context, FatalHang fatalHang) {
        Object object;
        void var2_2;
        block5: {
            if (fatalHang.getStateUri() == null) {
                FatalHangsSyncManagerImpl fatalHangsSyncManagerImpl = this;
                InstabugSDKLogger.i((String)"IBG-CR", (String)"No state file found. deleting Fatal hang");
                FatalHangsCacheManager fatalHangsCacheManager = fatalHangsSyncManagerImpl.fatalHangsCacheManager;
                String string = var2_2.getId();
                Intrinsics.checkNotNull((Object)string);
                fatalHangsCacheManager.delete(string);
                fatalHangsSyncManagerImpl.startFatalHangsSync();
                return;
            }
            InstabugSDKLogger.d((String)"IBG-CR", (String)("attempting to delete state file for Fatal hang with id: " + var2_2.getId()));
            try {
                // empty try
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                break block5;
            }
            {
                object = Result.constructor-impl((Object)DiskUtils.with((Context)object).deleteOperation((DiskOperation)new DeleteUriDiskOperation(var2_2.getStateUri())).execute());
            }
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"Unable to delete state file", (Throwable)throwable);
            object = null;
        }
        object = (Boolean)object;
        if (object == null) return;
        FatalHangsSyncManagerImpl fatalHangsSyncManagerImpl = this;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("result:" + (Boolean)object));
        InstabugSDKLogger.d((String)"IBG-CR", (String)("deleting FatalHang:" + var2_2.getId()));
        FatalHangsCacheManager fatalHangsCacheManager = fatalHangsSyncManagerImpl.fatalHangsCacheManager;
        String string = var2_2.getId();
        Intrinsics.checkNotNull((Object)string);
        fatalHangsCacheManager.delete(string);
        fatalHangsSyncManagerImpl.startFatalHangsSync();
    }

    private final void logRateIsLimited() {
        String string = String.format("You've reached the maximum number of requests in %s. You can read more about our rate limiting policy at this link: https://docs.instabug.com/docs/rate-limits", Arrays.copyOf(new Object[]{"Crashes"}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(this, *args)");
        InstabugSDKLogger.d((String)"IBG-CR", (String)string);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRateLimitException(FatalHang fatalHang, RateLimitedException exception) {
        void var1_1;
        void var2_2;
        CrashSettings.getInstance().setLimitedUntil(var2_2.getPeriod());
        this.handleRateIsLimited((FatalHang)var1_1);
    }

    private static final void syncFatalHangs$lambda$0(FatalHangsSyncManagerImpl this$0) {
        FatalHangsSyncManagerImpl fatalHangsSyncManagerImpl = this$0;
        Intrinsics.checkNotNullParameter((Object)fatalHangsSyncManagerImpl, (String)"this$0");
        InstabugSDKLogger.v((String)"IBG-CR", (String)"Starting Fatal hangs sync");
        fatalHangsSyncManagerImpl.startFatalHangsSync();
    }

    public static final /* synthetic */ FatalHangsCacheManager access$getFatalHangsCacheManager$p(FatalHangsSyncManagerImpl $this) {
        return $this.fatalHangsCacheManager;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$sendFatalHangAttachments(FatalHangsSyncManagerImpl $this, FatalHang fatalHang) {
        void var1_1;
        $this.sendFatalHangAttachments((FatalHang)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$deleteFatalHang(FatalHangsSyncManagerImpl $this, Context context, FatalHang fatalHang) {
        void var2_2;
        void var1_1;
        $this.deleteFatalHang((Context)var1_1, (FatalHang)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$handleSuccessfulRequest(FatalHangsSyncManagerImpl $this, FatalHang fatalHang, String id, Context context) {
        void var3_3;
        void var2_2;
        void var1_1;
        $this.handleSuccessfulRequest((FatalHang)var1_1, (String)var2_2, (Context)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$handleRateLimitException(FatalHangsSyncManagerImpl $this, FatalHang fatalHang, RateLimitedException exception) {
        void var2_2;
        void var1_1;
        $this.handleRateLimitException((FatalHang)var1_1, (RateLimitedException)var2_2);
    }

    @Override
    public void syncFatalHangs() {
        PoolProvider.getNetworkingSingleThreadExecutor((String)"CRASH").execute(() -> FatalHangsSyncManagerImpl.syncFatalHangs$lambda$0(this));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void sendFatalHangRequest(@NotNull FatalHang fatalHang, @NotNull Request.Callbacks<String, Throwable> callback) {
        void var2_2;
        Request.Callbacks<RequestResponse, Throwable> callbacks2;
        Request.Callbacks<RequestResponse, Throwable> callbacks3;
        Intrinsics.checkNotNullParameter((Object)callbacks3, (String)"fatalHang");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (CrashSettings.getInstance().isRateLimited()) {
            fatalHangsSyncManagerImpl2.handleRateIsLimited((FatalHang)callbacks3);
            return;
        }
        FatalHangsSyncManagerImpl fatalHangsSyncManagerImpl = fatalHangsSyncManagerImpl2;
        CrashSettings.getInstance().setLastRequestStartedAt(System.currentTimeMillis());
        FatalHangsSyncManagerImpl fatalHangsSyncManagerImpl2 = FatalHangsRequestsBuilder.INSTANCE.buildFatalHangRequest((FatalHang)callbacks3);
        callbacks3 = callbacks2;
        callbacks2 = new Request.Callbacks<RequestResponse, Throwable>((Request.Callbacks<String, Throwable>)var2_2){
            final /* synthetic */ Request.Callbacks<String, Throwable> $callback;
            {
                void var1_1;
                this.$callback = var1_1;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onSucceeded(@Nullable RequestResponse response) {
                JSONException jSONException2;
                block3: {
                    void var1_2;
                    if (response == null) return;
                    Request.Callbacks<String, Throwable> callbacks2 = callbacks2.$callback;
                    InstabugSDKLogger.v((String)"IBG-CR", (String)("sendFatalHangRequest Succeeded, Response code: " + var1_2.getResponseCode() + "Response body: " + var1_2.getResponseBody()));
                    try {
                        if (var1_2.getResponseBody() != null) {
                            Object object = var1_2.getResponseBody();
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                            callbacks2.onSucceeded((Object)new JSONObject((String)object).getString("id"));
                            return;
                        }
                    }
                    catch (JSONException jSONException2) {
                        break block3;
                    }
                    callbacks2.onFailed((Object)((Object)new JSONException("response.getResponseBody() returned null")));
                    return;
                }
                InstabugSDKLogger.e((String)"IBG-CR", (String)"Couldn't parse Fatal Hang request response.", (Throwable)jSONException2);
            }

            /*
             * WARNING - void declaration
             */
            public void onFailed(@Nullable Throwable error) {
                void var1_1;
                this.$callback.onFailed((Object)var1_1);
            }
        };
        fatalHangsSyncManagerImpl.getNetworkManager().doRequestOnSameThread(1, (Request)fatalHangsSyncManagerImpl2, (Request.Callbacks)callbacks3);
    }
}

