/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.commons.session;

import com.instabug.commons.di.CommonsLocator;
import com.instabug.commons.logging.ExtensionsKt;
import com.instabug.commons.models.Incident;
import com.instabug.commons.session.SessionIncident;
import com.instabug.commons.session.SessionIncidentCachingHandler;
import com.instabug.commons.session.SessionLinker;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.sessionV3.configurations.IBGSessionCrashesConfigurations;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\b\b\u0001\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J+\u0010\u0017\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J)\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0014\u0010\"\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010&\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lcom/instabug/commons/session/DefaultSessionLinker;", "Lcom/instabug/commons/session/SessionLinker;", "<init>", "()V", "Lcom/instabug/commons/session/SessionIncident;", "sessionIncident", "", "executePostStoreActions", "(Lcom/instabug/commons/session/SessionIncident;)V", "Lcom/instabug/commons/models/Incident;", "incident", "", "validationStatus", "link", "(Lcom/instabug/commons/models/Incident;I)V", "", "sessionId", "Lcom/instabug/commons/models/Incident$Type;", "type", "weakLink", "(Ljava/lang/String;Lcom/instabug/commons/models/Incident$Type;)V", "incidentId", "incidentType", "validateWeakLink", "(Ljava/lang/String;Ljava/lang/String;Lcom/instabug/commons/models/Incident$Type;)V", "", "sessionIds", "", "", "inspectDataReadiness", "(Ljava/util/List;)Ljava/util/Map;", "Lcom/instabug/commons/session/SessionIncidentCachingHandler;", "getCachingHandler", "()Lcom/instabug/commons/session/SessionIncidentCachingHandler;", "cachingHandler", "Lcom/instabug/library/sessionV3/configurations/IBGSessionCrashesConfigurations;", "getConfigurations", "()Lcom/instabug/library/sessionV3/configurations/IBGSessionCrashesConfigurations;", "configurations", "instabug-crash_defaultUiRelease"}, xi=48)
@SourceDebugExtension(value={"SMAP\nSessionLinker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionLinker.kt\ncom/instabug/commons/session/DefaultSessionLinker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,138:1\n1#2:139\n1477#3:140\n1502#3,3:141\n1505#3,3:151\n1238#3,2:156\n1789#3,3:158\n1241#3:161\n1271#3,2:162\n1285#3,4:164\n361#4,7:144\n442#4:154\n392#4:155\n*S KotlinDebug\n*F\n+ 1 SessionLinker.kt\ncom/instabug/commons/session/DefaultSessionLinker\n*L\n113#1:140\n113#1:141,3\n113#1:151,3\n114#1:156,2\n114#1:158,3\n114#1:161\n116#1:162,2\n116#1:164,4\n113#1:144,7\n114#1:154\n114#1:155\n*E\n"})
public final class DefaultSessionLinker
implements SessionLinker {
    private final SessionIncidentCachingHandler getCachingHandler() {
        return CommonsLocator.INSTANCE.getSessionIncidentCachingHandler();
    }

    private final IBGSessionCrashesConfigurations getConfigurations() {
        return CommonsLocator.INSTANCE.getSessionCrashesConfigurations();
    }

    /*
     * WARNING - void declaration
     */
    private final void executePostStoreActions(SessionIncident sessionIncident) {
        void var1_1;
        Incident.Type type = sessionIncident.getIncidentType();
        int n = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    this.getCachingHandler().trim(var1_1.getSessionId(), type, this.getConfigurations().getFatalHangStoreLimit());
                }
            } else {
                this.getCachingHandler().trim(var1_1.getSessionId(), type, this.getConfigurations().getAnrStoreLimit());
            }
        } else {
            this.getCachingHandler().trim(var1_1.getSessionId(), type, this.getConfigurations().getNonFatalStoreLimit());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void link(@NotNull Incident incident, int validationStatus) {
        void var2_2;
        void var1_1;
        SessionIncident sessionIncident;
        Incident incident2 = incident;
        Intrinsics.checkNotNullParameter((Object)incident2, (String)"incident");
        String string = incident2.getMetadata().getUuid();
        if (string == null) {
            ExtensionsKt.logVerbose("Session-Incident linking failed, incident doesn't have uuid");
            return;
        }
        String string2 = InstabugCore.getLatestV3SessionId();
        if (string2 == null) {
            ExtensionsKt.logVerbose("Session-Incident linking failed, v3 session is not available");
            return;
        }
        SessionIncident sessionIncident2 = sessionIncident;
        sessionIncident2(string2, string, var1_1.getType(), (int)var2_2, 0L, 16, null);
        this.getCachingHandler().store(sessionIncident2);
        this.executePostStoreActions(sessionIncident);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void weakLink(@NotNull String sessionId, @NotNull Incident.Type type) {
        void var2_2;
        SessionIncident sessionIncident;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String string = InstabugCore.getLatestV3SessionId();
        if (string == null) {
            ExtensionsKt.logVerbose("Session-Incident linking failed, v3 session is not available");
            return;
        }
        if (!Intrinsics.areEqual((Object)var1_1, (Object)string)) {
            ExtensionsKt.logVerbose("Session id provided for weak link doesn't match latest v3 session id, aborting ..");
            return;
        }
        SessionIncident sessionIncident2 = sessionIncident;
        sessionIncident2(string, null, (Incident.Type)var2_2, 0, 0L, 16, null);
        this.getCachingHandler().store(sessionIncident2);
        this.executePostStoreActions(sessionIncident);
        ExtensionsKt.logVerbose("Trm weak link created for session " + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateWeakLink(@Nullable String sessionId, @Nullable String incidentId, @NotNull Incident.Type incidentType) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"incidentType");
        if (sessionId == null) {
            ExtensionsKt.logVerbose("Session-Incident linking failed, v3 session is not available");
            return;
        }
        this.getCachingHandler().updateValidationStatus((String)var1_1, (String)var2_2, (Incident.Type)var3_3, 1);
    }

    @Override
    @NotNull
    public Map<String, Boolean> inspectDataReadiness(@NotNull List<String> sessionIds) {
        LinkedHashMap linkedHashMap;
        LinkedHashMap linkedHashMap2;
        Object this_;
        LinkedHashMap linkedHashMap3;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object2, (String)"sessionIds");
        Object object = linkedHashMap3;
        linkedHashMap3 = new LinkedHashMap();
        for (Object object3 : ((DefaultSessionLinker)this_).getCachingHandler().queryIncidentsBySessionsIds((List<String>)object2)) {
            String string = ((SessionIncident)object3).getSessionId();
            Object object4 = object.get(string);
            if (object4 == null) {
                ArrayList arrayList;
                object4 = arrayList;
                arrayList = new ArrayList();
                object.put(string, object4);
            }
            ((List)object4).add(object3);
        }
        Object object5 = linkedHashMap2;
        linkedHashMap2 = new LinkedHashMap(MapsKt.mapCapacity((int)object.size()));
        for (Map.Entry entry : object.entrySet()) {
            Object k = entry.getKey();
            boolean bl = true;
            for (SessionIncident sessionIncident : (Iterable)entry.getValue()) {
                if (bl && sessionIncident.isValidated()) {
                    bl = true;
                    continue;
                }
                bl = false;
            }
            object5.put(k, bl);
        }
        object = MapsKt.toMutableMap((Map)object5);
        object2 = CollectionsKt.minus((Iterable)object2, object.keySet());
        object5 = linkedHashMap;
        linkedHashMap = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10)), (int)16));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object e = object2.next();
            String cfr_ignored_0 = (String)e;
            object5.put(e, Boolean.TRUE);
        }
        Object object6 = object;
        object6.putAll(object5);
        return object6;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public abstract class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Incident.Type.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[Incident.Type.NonFatalCrash.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Incident.Type.ANR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Incident.Type.FatalHang.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

