package com.instabug.early_crash.caching

import android.content.Context
import com.instabug.library.internal.filestore.Directory
import com.instabug.library.internal.filestore.DirectoryFactory
import com.instabug.library.util.extenstions.toDirectory
import java.io.File

private const val REPORTS_DIRECTORY_NAME = "early_crashes"

class ReportsDirectory(parent: Directory) : Directory(parent, REPORTS_DIRECTORY_NAME) {
    fun reportFile(id: String) = File(this, "$id.txt")
    class Factory(
        private val ctxGetter: () -> Context?,
        private val rootDirGetter: (Context) -> File?
    ) : DirectoryFactory<ReportsDirectory> {
        override fun invoke(): ReportsDirectory? =
            ctxGetter()?.let(rootDirGetter)
                ?.toDirectory()
                ?.let(::ReportsDirectory)
    }
}