package com.instabug.commons.models

import android.content.Context
import java.io.File

/**
 * Base contract for crashes incidents
 */
interface Incident {
    /**
     * Metadata object
     */
    val metadata: IncidentMetadata

    /**
     * Incident type name in readable format
     * @see Type
     */
    val type: Type

    fun getSavingDirOnDisk(ctx: Context): File

    enum class Type { FatalCrash, NonFatalCrash, ANR, BG_ANR, Termination, NDKCrash, FatalHang }
}
