package com.instabug.commons.logging

import com.instabug.crash.Constants
import com.instabug.library.core.InstabugCore
import com.instabug.library.util.InstabugSDKLogger

fun <T> Result<T>.runOrLogError(message: String) =
    onFailure {
        message.logError()
    }

fun <R> Result<R>.getOrReportError(
    default: R,
    message: String,
    withThrowable: Boolean = false
): R = runOrReportError(message, withThrowable).getOrElse { default }

fun Result<Unit>.getOrReportError(message: String, withThrowable: Boolean = true): Unit =
    getOrReportError(Unit, message, withThrowable)

fun <R> Result<R>.runOrReportError(message: String, withThrowable: Boolean = false): Result<R> =
    onFailure { t -> InstabugCore.reportError(t, message + t.message.orEmpty()) }
        .onFailure { t -> (message + t.message.orEmpty()).logError(if (withThrowable) t else null) }

fun String.logVerbose() {
    InstabugSDKLogger.v(Constants.LOG_TAG, this)
}
fun String.logDebug() {
    InstabugSDKLogger.d(Constants.LOG_TAG, this)
}

fun String.logWarning() {
    InstabugSDKLogger.w(Constants.LOG_TAG, this)
}

fun String.logError() {
    InstabugSDKLogger.e(Constants.LOG_TAG, this)
}

fun String.logError(throwable: Throwable? = null) {
    throwable?.let { InstabugSDKLogger.e(Constants.LOG_TAG, this, it) }
        ?: InstabugSDKLogger.e(Constants.LOG_TAG, this)
}