/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.early_crash.network;

import com.instabug.commons.logging.ExtensionsKt;
import com.instabug.crash.settings.CrashSettings;
import com.instabug.early_crash.caching.IEarlyCrashCacheHandler;
import com.instabug.early_crash.network.SingleEarlyCrashUploader;
import com.instabug.early_crash.network.SynchronousSingleEarlyCrashUploader;
import com.instabug.early_crash.threading.ExecutionMode;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.factory.ParameterizedFactory;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.TimeUtils;
import com.instabug.library.util.threading.SimpleCompletableFuture;
import java.util.Arrays;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J;\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001aH\u0096\u0002J\"\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010 \u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00112\b\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J>\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/instabug/early_crash/network/SynchronousSingleEarlyCrashUploader;", "Lcom/instabug/early_crash/network/SingleEarlyCrashUploader;", "Ljava/lang/Runnable;", "cacheHandler", "Lcom/instabug/early_crash/caching/IEarlyCrashCacheHandler;", "requestFactory", "Lcom/instabug/library/factory/ParameterizedFactory;", "Lcom/instabug/library/networkv2/request/Request;", "Lorg/json/JSONObject;", "networkManager", "Lcom/instabug/library/networkv2/NetworkManager;", "crashSettings", "Lcom/instabug/crash/settings/CrashSettings;", "(Lcom/instabug/early_crash/caching/IEarlyCrashCacheHandler;Lcom/instabug/library/factory/ParameterizedFactory;Lcom/instabug/library/networkv2/NetworkManager;Lcom/instabug/crash/settings/CrashSettings;)V", "handleRateLimit", "", "id", "", "cacheExecMode", "Lcom/instabug/early_crash/threading/ExecutionMode;", "handleRateLimitResponse", "exception", "Lcom/instabug/library/networkv2/RateLimitedException;", "invoke", "jsonObject", "successHandler", "Lkotlin/Function1;", "Lcom/instabug/library/networkv2/RequestResponse;", "onSyncFailure", "crashId", "error", "", "onSyncSuccess", "response", "syncCrash", "Ljava/util/concurrent/Future;", "instabug-crash_defaultUiRelease"})
public final class SynchronousSingleEarlyCrashUploader
implements SingleEarlyCrashUploader<Runnable> {
    @NotNull
    private final IEarlyCrashCacheHandler cacheHandler;
    @NotNull
    private final ParameterizedFactory<Request, JSONObject> requestFactory;
    @NotNull
    private final NetworkManager networkManager;
    @NotNull
    private final CrashSettings crashSettings;

    /*
     * WARNING - void declaration
     */
    public SynchronousSingleEarlyCrashUploader(@NotNull IEarlyCrashCacheHandler cacheHandler2, @NotNull ParameterizedFactory<Request, JSONObject> requestFactory, @NotNull NetworkManager networkManager2, @NotNull CrashSettings crashSettings) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cacheHandler");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"requestFactory");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"networkManager");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"crashSettings");
        this.cacheHandler = var1_1;
        this.requestFactory = var2_2;
        this.networkManager = var3_3;
        this.crashSettings = var4_4;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRateLimit(String id, ExecutionMode cacheExecMode) {
        void var2_2;
        void var1_1;
        ((SynchronousSingleEarlyCrashUploader)((Object)this_)).cacheHandler.delete((String)var1_1, (ExecutionMode)var2_2);
        String this_ = String.format("You've reached the maximum number of requests in %s. You can read more about our rate limiting policy at this link: https://docs.instabug.com/docs/rate-limits", Arrays.copyOf(new Object[]{"Crashes"}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"format(format, *args)");
        InstabugSDKLogger.d((String)"IBG-CR", (String)this_);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRateLimitResponse(String id, ExecutionMode cacheExecMode, RateLimitedException exception) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.crashSettings.setLimitedUntil(var3_3.getPeriod());
        this.handleRateLimit((String)var1_1, (ExecutionMode)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final Future<Runnable> syncCrash(String id, JSONObject jsonObject, ExecutionMode cacheExecMode, Function1<? super RequestResponse, Unit> successHandler) {
        Request request;
        SimpleCompletableFuture simpleCompletableFuture;
        SimpleCompletableFuture simpleCompletableFuture2 = simpleCompletableFuture;
        simpleCompletableFuture = new SimpleCompletableFuture();
        if ((request = (Request)this.requestFactory.create((Object)request)) != null) {
            void var4_4;
            void var3_3;
            void var1_1;
            Request.Callbacks<RequestResponse, Throwable> callbacks2;
            SynchronousSingleEarlyCrashUploader synchronousSingleEarlyCrashUploader = this;
            synchronousSingleEarlyCrashUploader.crashSettings.setLastRequestStartedAt(TimeUtils.currentTimeMillis());
            Request.Callbacks<RequestResponse, Throwable> callbacks3 = callbacks2;
            callbacks2 = new Request.Callbacks<RequestResponse, Throwable>((SimpleCompletableFuture<Runnable>)simpleCompletableFuture2, this, (String)var1_1, (ExecutionMode)var3_3, (Function1<? super RequestResponse, Unit>)var4_4){
                final /* synthetic */ SimpleCompletableFuture<Runnable> $completableFuture;
                final /* synthetic */ SynchronousSingleEarlyCrashUploader this$0;
                final /* synthetic */ String $id;
                final /* synthetic */ ExecutionMode $cacheExecMode;
                final /* synthetic */ Function1<RequestResponse, Unit> $successHandler;
                {
                    void var5_5;
                    void var4_4;
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.$completableFuture = var1_1;
                    this.this$0 = var2_2;
                    this.$id = var3_3;
                    this.$cacheExecMode = var4_4;
                    this.$successHandler = var5_5;
                }

                /*
                 * WARNING - void declaration
                 */
                private static final void onSucceeded$lambda$0(SynchronousSingleEarlyCrashUploader this$0, String $id, RequestResponse $response, ExecutionMode $cacheExecMode, Function1 $successHandler) {
                    void var2_2;
                    void var3_3;
                    void var1_1;
                    SynchronousSingleEarlyCrashUploader synchronousSingleEarlyCrashUploader;
                    Intrinsics.checkNotNullParameter((Object)synchronousSingleEarlyCrashUploader, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$id");
                    Intrinsics.checkNotNullParameter((Object)var3_3, (String)"$cacheExecMode");
                    SynchronousSingleEarlyCrashUploader.access$onSyncSuccess(synchronousSingleEarlyCrashUploader, (String)var1_1, (RequestResponse)var2_2, (ExecutionMode)var3_3);
                    if ($successHandler != null) {
                        void var4_4;
                        var4_4.invoke((Object)var2_2);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private static final void onFailed$lambda$1(SynchronousSingleEarlyCrashUploader this$0, String $id, Throwable $error, ExecutionMode $cacheExecMode) {
                    void var2_2;
                    void var3_3;
                    void var1_1;
                    SynchronousSingleEarlyCrashUploader synchronousSingleEarlyCrashUploader;
                    Intrinsics.checkNotNullParameter((Object)synchronousSingleEarlyCrashUploader, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$id");
                    Intrinsics.checkNotNullParameter((Object)var3_3, (String)"$cacheExecMode");
                    SynchronousSingleEarlyCrashUploader.access$onSyncFailure(this$0, (String)var1_1, (Throwable)var2_2, (ExecutionMode)var3_3);
                }

                /*
                 * WARNING - void declaration
                 */
                public void onSucceeded(@Nullable RequestResponse response) {
                    void var1_1;
                    syncCrash.1.1 v0 = this_;
                    String this_ = v0.$id;
                    ExecutionMode executionMode = v0.$cacheExecMode;
                    Function1<RequestResponse, Unit> function1 = v0.$successHandler;
                    this_.$completableFuture.complete(() -> syncCrash.1.1.onSucceeded$lambda$0(this_.this$0, this_, (RequestResponse)var1_1, executionMode, function1));
                }

                /*
                 * WARNING - void declaration
                 */
                public void onFailed(@Nullable Throwable error) {
                    void var1_1;
                    syncCrash.1.1 v0 = this_;
                    String this_ = v0.$id;
                    ExecutionMode executionMode = v0.$cacheExecMode;
                    this_.$completableFuture.complete(() -> syncCrash.1.1.onFailed$lambda$1(this_.this$0, this_, (Throwable)var1_1, executionMode));
                }
            };
            synchronousSingleEarlyCrashUploader.networkManager.doRequestOnSameThread(1, request, true, (Request.Callbacks)callbacks3);
        }
        if (!simpleCompletableFuture2.isDone()) {
            simpleCompletableFuture2.complete(SynchronousSingleEarlyCrashUploader::syncCrash$lambda$3);
        }
        return simpleCompletableFuture2;
    }

    /*
     * WARNING - void declaration
     */
    private final void onSyncSuccess(String crashId, RequestResponse response, ExecutionMode cacheExecMode) {
        Integer n;
        void var3_3;
        StringBuilder stringBuilder;
        SynchronousSingleEarlyCrashUploader synchronousSingleEarlyCrashUploader = this;
        synchronousSingleEarlyCrashUploader.cacheHandler.delete((String)((Object)stringBuilder), (ExecutionMode)var3_3);
        synchronousSingleEarlyCrashUploader.crashSettings.setLastRequestStartedAt(0L);
        stringBuilder = new StringBuilder().append("reporting EarlyCrash request Succeeded, Response code: ");
        n = response != null ? Integer.valueOf(n.getResponseCode()) : null;
        ExtensionsKt.logVerbose(stringBuilder.append(n).toString());
        this.crashSettings.setLastCrashTime(TimeUtils.currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    private final void onSyncFailure(String crashId, Throwable error, ExecutionMode cacheExecMode) {
        String string;
        Object object;
        void var2_2;
        if (error instanceof RateLimitedException) {
            void var3_3;
            SynchronousSingleEarlyCrashUploader synchronousSingleEarlyCrashUploader = object;
            object = (RateLimitedException)var2_2;
            synchronousSingleEarlyCrashUploader.handleRateLimitResponse(string, (ExecutionMode)var3_3, (RateLimitedException)object);
        } else {
            object = new StringBuilder().append("Reporting early crash got an error ");
            string = var2_2 != null ? var2_2.getMessage() : null;
            IBGDiagnostics.reportNonFatalAndLog((Throwable)var2_2, (String)((StringBuilder)object).append(string).toString(), (String)"IBG-CR");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void invoke$lambda$1$lambda$0(SynchronousSingleEarlyCrashUploader $this_runCatching, String $id, ExecutionMode $cacheExecMode) {
        void var2_2;
        void var1_1;
        SynchronousSingleEarlyCrashUploader synchronousSingleEarlyCrashUploader;
        Intrinsics.checkNotNullParameter((Object)synchronousSingleEarlyCrashUploader, (String)"$this_runCatching");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$id");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"$cacheExecMode");
        $this_runCatching.handleRateLimit((String)var1_1, (ExecutionMode)var2_2);
    }

    private static final void syncCrash$lambda$3() {
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$onSyncSuccess(SynchronousSingleEarlyCrashUploader $this, String crashId, RequestResponse response, ExecutionMode cacheExecMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        $this.onSyncSuccess((String)var1_1, (RequestResponse)var2_2, (ExecutionMode)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$onSyncFailure(SynchronousSingleEarlyCrashUploader $this, String crashId, Throwable error, ExecutionMode cacheExecMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        $this.onSyncFailure((String)var1_1, (Throwable)var2_2, (ExecutionMode)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Runnable invoke(@NotNull String id, @NotNull JSONObject jsonObject, @NotNull ExecutionMode cacheExecMode, @Nullable Function1<? super RequestResponse, Unit> successHandler) {
        Object this_;
        Throwable throwable2;
        block3: {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"id");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"jsonObject");
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"cacheExecMode");
            try {
                // empty try
            }
            catch (Throwable throwable2) {
                break block3;
            }
            this_ = ((SynchronousSingleEarlyCrashUploader)this_).crashSettings.isRateLimited() ? () -> SynchronousSingleEarlyCrashUploader.invoke$lambda$1$lambda$0((SynchronousSingleEarlyCrashUploader)this_, (String)var1_1, (ExecutionMode)var3_3) : ((SynchronousSingleEarlyCrashUploader)this_).syncCrash((String)var1_1, (JSONObject)var2_2, (ExecutionMode)var3_3, (Function1<? super RequestResponse, Unit>)var4_4).get();
            this_ = Result.constructor-impl((Object)this_);
            return (Runnable)ExtensionsKt.getOrReportError(this_, null, "Error while syncing early crashes", true);
        }
        this_ = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
        return ExtensionsKt.getOrReportError(this_, null, "Error while syncing early crashes", true);
    }
}

