/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash.models;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.commons.AttachmentsHolder;
import com.instabug.commons.BasicAttachmentsHolder;
import com.instabug.commons.caching.DiskHelper;
import com.instabug.commons.models.Incident;
import com.instabug.commons.models.IncidentMetadata;
import com.instabug.crash.di.CrashesServiceLocator;
import com.instabug.crash.models.IBGNonFatalException;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.util.List;
import kotlin.Pair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Crash
implements Incident,
Cacheable,
AttachmentsHolder {
    private final String id;
    @Nullable
    private String temporaryServerToken;
    @Nullable
    private String crashMessage;
    private final AttachmentsHolder attachmentsHolder;
    @Nullable
    private State state;
    private CrashState crashState;
    private boolean handled;
    private int retryCount;
    @Nullable
    private String threadsDetails;
    @Nullable
    private String fingerprint;
    @Nullable
    private IBGNonFatalException.Level level;
    @NonNull
    private IncidentMetadata metadata;

    /*
     * WARNING - void declaration
     */
    public Crash(@NonNull String id, @NonNull IncidentMetadata metadata) {
        void var2_2;
        void var1_1;
        Crash crash = this;
        this.id = var1_1;
        crash.metadata = var2_2;
        crash.crashState = CrashState.NOT_AVAILABLE;
        crash.attachmentsHolder = new BasicAttachmentsHolder();
    }

    /*
     * WARNING - void declaration
     */
    public Crash(@NonNull String id, @Nullable State state, @NonNull IncidentMetadata metadata) {
        this((String)var1_1, (IncidentMetadata)var3_3);
        void var2_2;
        void var3_3;
        void var1_1;
        this.state = var2_2;
        this.retryCount = 0;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getTemporaryServerToken() {
        return this.temporaryServerToken;
    }

    /*
     * WARNING - void declaration
     */
    public Crash setTemporaryServerToken(String temporaryServerToken) {
        void var1_1;
        this.temporaryServerToken = var1_1;
        return this;
    }

    @Nullable
    public String getCrashMessage() {
        return this.crashMessage;
    }

    /*
     * WARNING - void declaration
     */
    public Crash setCrashMessage(String crashMessage) {
        void var1_1;
        this.crashMessage = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Crash setThreadsDetails(@Nullable String threadsDetails) {
        void var1_1;
        this.threadsDetails = var1_1;
        return this;
    }

    @Nullable
    public String getThreadsDetails() {
        return this.threadsDetails;
    }

    /*
     * WARNING - void declaration
     */
    public Crash addAttachment(Uri attachmentUri) {
        void var1_1;
        Crash crash = this;
        crash.addAttachment((Uri)var1_1, Attachment.Type.ATTACHMENT_FILE, false);
        return crash;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    public Crash setState(State state) {
        void var1_1;
        this.state = var1_1;
        return this;
    }

    public CrashState getCrashState() {
        return this.crashState;
    }

    /*
     * WARNING - void declaration
     */
    public Crash setCrashState(CrashState crashState) {
        void var1_1;
        this.crashState = var1_1;
        return this;
    }

    public boolean isHandled() {
        return this.handled;
    }

    /*
     * WARNING - void declaration
     */
    public Crash setHandled(boolean handled) {
        void var1_1;
        this.handled = var1_1;
        return this;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    /*
     * WARNING - void declaration
     */
    public void setRetryCount(int retryCount) {
        void var1_1;
        this.retryCount = var1_1;
    }

    @Nullable
    public String getFingerprint() {
        return this.fingerprint;
    }

    /*
     * WARNING - void declaration
     */
    public void setFingerprint(@Nullable String fingerprint) {
        void var1_1;
        this.fingerprint = var1_1;
    }

    @Nullable
    public IBGNonFatalException.Level getLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    public void setLevel(@Nullable IBGNonFatalException.Level level) {
        void var1_1;
        this.level = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setLevel(int severity) {
        void var1_1;
        this.level = IBGNonFatalException.Level.parse((int)var1_1);
    }

    public String toJson() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject.put("id", (Object)this.getId()).put("temporary_server_token", (Object)this.getTemporaryServerToken()).put("crash_message", (Object)this.getCrashMessage()).put("crash_state", (Object)((Object)((Object)this.getCrashState())).toString()).put("attachments", (Object)Attachment.toJson(this.getAttachments())).put("handled", this.isHandled()).put("retry_count", this.getRetryCount()).put("threads_details", (Object)this.getThreadsDetails()).put("fingerprint", (Object)this.getFingerprint());
        IBGNonFatalException.Level level = this.getLevel();
        if (level != null) {
            jSONObject2.put("level", level.getSeverity());
        }
        if (this.getState() != null) {
            jSONObject2.put("state", (Object)this.getState().toJson());
        } else {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"Error parsing crash: state is null");
        }
        return jSONObject2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void fromJson(String crashASJson) throws JSONException {
        void var1_1;
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject((String)var1_1);
        if (jSONObject2.has("temporary_server_token")) {
            this.setTemporaryServerToken(jSONObject2.getString("temporary_server_token"));
        }
        if (jSONObject2.has("crash_message")) {
            this.setCrashMessage(jSONObject2.getString("crash_message"));
        }
        if (jSONObject2.has("crash_state")) {
            this.setCrashState(CrashState.valueOf(jSONObject2.getString("crash_state")));
        }
        if (jSONObject2.has("state")) {
            State state = new State();
            state.fromJson(jSONObject2.getString("state"));
            this.setState(state);
        }
        if (jSONObject2.has("attachments")) {
            this.setAttachments(Attachment.fromJson((JSONArray)jSONObject2.getJSONArray("attachments")));
        }
        if (jSONObject2.has("handled")) {
            this.setHandled(jSONObject2.getBoolean("handled"));
        }
        if (jSONObject2.has("retry_count")) {
            this.setRetryCount(jSONObject2.getInt("retry_count"));
        }
        if (jSONObject2.has("threads_details")) {
            this.setThreadsDetails(jSONObject2.getString("threads_details"));
        }
        if (jSONObject2.has("fingerprint")) {
            this.setFingerprint(jSONObject2.getString("fingerprint"));
        }
        if (jSONObject2.has("level")) {
            this.setLevel(jSONObject2.getInt("level"));
        }
    }

    @Override
    @NonNull
    public IncidentMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @NonNull
    public Incident.Type getType() {
        if (this.handled) {
            return Incident.Type.NonFatalCrash;
        }
        return Incident.Type.FatalCrash;
    }

    public String toString() {
        return "Internal Id: " + this.id + ", TemporaryServerToken:" + this.temporaryServerToken + ", crashMessage:" + this.crashMessage + ", handled:" + this.handled + ", retryCount:" + this.retryCount + ", threadsDetails:" + this.threadsDetails + ", fingerprint:" + this.fingerprint + ", level:" + (Object)((Object)this.level);
    }

    @SuppressLint(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object crash) {
        Crash crash2;
        if (crash == null) {
            return false;
        }
        if (crash2 instanceof Crash) {
            if (String.valueOf((crash2 = (Crash)crash2).getId()).equals(String.valueOf(this.getId())) && String.valueOf(crash2.getCrashMessage()).equals(String.valueOf(this.getCrashMessage())) && String.valueOf(crash2.getTemporaryServerToken()).equals(String.valueOf(this.getTemporaryServerToken())) && crash2.getCrashState() == this.getCrashState() && crash2.getState() != null && crash2.getState().equals((Object)this.getState()) && crash2.isHandled() == this.isHandled() && crash2.getRetryCount() == this.getRetryCount() && crash2.getAttachments() != null && crash2.getAttachments().size() == this.getAttachments().size() && (crash2.getThreadsDetails() == null && this.getThreadsDetails() == null || crash2.getThreadsDetails() != null && crash2.getThreadsDetails().equals(this.getThreadsDetails())) && (crash2.getFingerprint() == null && this.getFingerprint() == null || crash2.getFingerprint() != null && crash2.getFingerprint().equals(this.getFingerprint())) && (crash2.getLevel() == null && this.getLevel() == null || crash2.getLevel() != null && ((Object)((Object)crash2.getLevel())).equals((Object)this.getLevel()))) {
                for (int i = 0; i < crash2.getAttachments().size(); ++i) {
                    if (crash2.getAttachments().get(i).equals((Object)this.getAttachments().get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return -1;
    }

    @Override
    @NonNull
    public File getSavingDirOnDisk(@NonNull Context ctx) {
        Crash crash = string;
        String string = crash.getType().name();
        return DiskHelper.getIncidentSavingDirectory(ctx, string, crash.id);
    }

    @Override
    @NonNull
    public List<Attachment> getAttachments() {
        return this.attachmentsHolder.getAttachments();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addAttachment(@Nullable Uri uri, @NonNull Attachment.Type type, boolean isEncrypted) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.attachmentsHolder.addAttachment((Uri)var1_1, (Attachment.Type)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAttachments(@NonNull List<? extends Attachment> attachments) {
        void var1_1;
        this.attachmentsHolder.setAttachments((List<? extends Attachment>)var1_1);
    }

    public static enum CrashState {
        READY_TO_BE_SENT,
        LOGS_READY_TO_BE_UPLOADED,
        ATTACHMENTS_READY_TO_BE_UPLOADED,
        NOT_AVAILABLE,
        WAITING_FOR_SCREEN_RECORDING_TO_BE_TRIMMED;

    }

    public static class Factory {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static void updateReproInteractionsIfApplicable(@NonNull Crash crash) {
            Throwable throwable2;
            block4: {
                State state;
                try {
                    state = crash.getState();
                    if (state == null) return;
                }
                catch (Throwable throwable2) {
                    break block4;
                }
                {
                    Crash crash2;
                    if (!Factory.shouldUpdateReproInteractions(crash2)) {
                        return;
                    }
                    state.updateVisualUserSteps();
                    return;
                }
            }
            IBGDiagnostics.reportNonFatal((Throwable)throwable2, (String)("Error while updating Repro interactions in crash incident: " + throwable2.getMessage()));
        }

        @WorkerThread
        public static void addReproScreenshotsAttachmentIfApplicable(@NonNull Crash crash, @NonNull Context context) {
            Crash crash2;
            Pair<String, Boolean> pair;
            block10: {
                File file;
                block9: {
                    block8: {
                        if (Factory.shouldAddReproScreenshotAttachmentToCrash(crash)) break block8;
                        return;
                    }
                    file = (File)CrashesServiceLocator.getReproScreenshotsCacheDir().getCurrentSpanDirectory();
                    if (file != null) break block9;
                    return;
                }
                void v0 = pair;
                Crash crash3 = crash2;
                void v2 = pair;
                pair = crash2.getId();
                pair = DiskHelper.getReproScreenshotsZipPath((Context)v0, (String)pair, crash3.getSavingDirOnDisk((Context)v2), file);
                if (pair.getFirst() != null) break block10;
                return;
            }
            Crash crash4 = crash2;
            Uri uri = Uri.parse((String)((String)pair.getFirst()));
            Pair<String, Boolean> pair2 = pair;
            crash2 = Attachment.Type.VISUAL_USER_STEPS;
            try {
                crash4.addAttachment(uri, (Attachment.Type)crash2, (Boolean)pair2.getSecond());
            }
            catch (Throwable throwable) {
                IBGDiagnostics.reportNonFatal((Throwable)throwable, (String)("Error while adding Repro screenshots attachment to crash incident: " + throwable.getMessage()));
            }
        }

        private static boolean shouldAddReproScreenshotAttachmentToCrash(@NonNull Crash crash) {
            return (crash.isHandled() ? CrashesServiceLocator.getNonFatalsConfigurationsProvider() : CrashesServiceLocator.getReproConfigurationsProvider()).isReproScreenshotsEnabled();
        }

        private static boolean shouldUpdateReproInteractions(@NonNull Crash crash) {
            return (crash.isHandled() ? CrashesServiceLocator.getNonFatalsConfigurationsProvider() : CrashesServiceLocator.getReproConfigurationsProvider()).isReproStepsEnabled();
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"CheckResult"})
        public Crash create(@Nullable State state, @NonNull Context context, boolean handled) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.create((State)var1_1, (Context)var2_2, (boolean)var3_3, true);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Crash create(@Nullable State state, @NonNull Context context, boolean handled, boolean withStateLogsAndAttachments) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            return this.create(System.currentTimeMillis() + "", (State)var1_1, IncidentMetadata.Factory.create(), (Context)var2_2, (boolean)var3_3, (boolean)var4_4);
        }

        /*
         * WARNING - void declaration
         */
        public Crash create(@NonNull String id, @NonNull IncidentMetadata metadata) {
            void var2_2;
            void var1_1;
            return new Crash((String)var1_1, (IncidentMetadata)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Crash create(@NonNull String id, @Nullable State state, @NonNull IncidentMetadata metadata, @NonNull Context context, boolean handled, boolean withStateLogsAndAttachments) {
            void var5_5;
            void var3_3;
            void var2_2;
            void var1_1;
            Crash crash;
            Crash crash2 = crash;
            new Crash((String)var1_1, (State)var2_2, (IncidentMetadata)var3_3).setHandled((boolean)var5_5);
            if (withStateLogsAndAttachments) {
                void var4_4;
                Crash crash3 = crash2;
                Factory.updateReproInteractionsIfApplicable(crash3);
                Factory.addReproScreenshotsAttachmentIfApplicable(crash3, (Context)var4_4);
            }
            return crash2;
        }
    }
}

