package com.instabug.early_crash.configurations

import com.instabug.crash.configurations.CrashConfigurationProvider
import com.instabug.crash.utils.CrashReportingUtility

interface IEarlyCrashesConfigProvider {
    val isEarlyCrashesAvailable: Boolean
    val isEarlyCrashesEnabled: Boolean
    val maxCachedReports: Int
    val immediateSyncEnabled: Boolean
    fun setEarlyCrashesAvailable(isAvailable: Boolean)
}

private const val DEFAULT_MAX_CACHED_REPORTS = 100

class EarlyCrashesConfigProvider(
    private val persistence: EarlyCrashesConfigPersistence,
    private val crashConfigurationProvider: CrashConfigurationProvider
) : IEarlyCrashesConfigProvider {
    override val isEarlyCrashesAvailable: Boolean
        get() = persistence.isEarlyCrashCaptureEnabled()
    override val isEarlyCrashesEnabled: Boolean
        get() = isEarlyCrashesAvailable && CrashReportingUtility.isCrashReportingEnabled()

    override val maxCachedReports: Int
        get() = DEFAULT_MAX_CACHED_REPORTS

    override val immediateSyncEnabled: Boolean
        get() = crashConfigurationProvider.isMetadataImmediateSyncAvailable

    override fun setEarlyCrashesAvailable(isAvailable: Boolean) {
        persistence.setEarlyCrashCaptureEnabled(isAvailable)
    }

}