package com.instabug.crash.settings;

import android.annotation.SuppressLint;
import android.content.Context;

import com.instabug.library.networkv2.limitation.RateLimitationSettings;


/**
 * Created by mohamednagy on 11/19/17.
 */

public class CrashSettings implements RateLimitationSettings {
    private static CrashSettings settingsManager;

    private CrashSettings() {
    }

    public synchronized static void init() {
        settingsManager = new CrashSettings();
        PersistableSettings.init();
    }

    /**
     * Returns the current singleton instance of this class.
     *
     * @return a {@code BugSettings} instance
     */
    public synchronized static CrashSettings getInstance() {
        if (settingsManager == null) {
            settingsManager = new CrashSettings();
        }
        return settingsManager;
    }

    @SuppressLint("ERADICATE_FIELD_NOT_NULLABLE")
    public synchronized static void release() {
        PerSessionSettings.release();
        PersistableSettings.release();
        settingsManager = null;
    }

    public synchronized void setLastCrashTime(long time) {
        if (PersistableSettings.getInstance() == null) return;
        PersistableSettings.getInstance().setLastCrashTime(time);
    }

    public synchronized long getLastCrashTime() {
        if (PersistableSettings.getInstance() == null) return -1;
        return PersistableSettings.getInstance().getLastCrashTime();
    }

    public synchronized boolean isFirstRunAfterEncryptorUpdate() {
        if (PersistableSettings.getInstance() == null) return false;
        return PersistableSettings.getInstance().isFirstRunAfterEncryptorUpdate();
    }

    public synchronized void setFirstRunAfterEncryptorUpdate(boolean isFirstRun) {
        if (PersistableSettings.getInstance() == null) return;
        PersistableSettings.getInstance().setFirstRunAfterEncryptorUpdate(isFirstRun);
    }

    @Override
    public synchronized void setLastRequestStartedAt(long time) {
        if (PersistableSettings.getInstance() == null) return;
        PersistableSettings.getInstance().setLastCrashRequestStartedAt(time);
    }

    @Override
    public synchronized void setLimitedUntil(int period) {
        if (PersistableSettings.getInstance() == null) return;
        PersistableSettings.getInstance().setCrashesLimitedUntil(period);
    }

    @Override
    public synchronized boolean isRateLimited() {
        if (PersistableSettings.getInstance() == null) return false;

        long start = PersistableSettings.getInstance().getLastCrashRequestStartedAt();
        long limitedUntil = PersistableSettings.getInstance().getCrashesLimitedUntil();
        long currentTime = System.currentTimeMillis();
        return start != 0 && limitedUntil != 0
                && currentTime > start && currentTime < limitedUntil;
    }
}
