package com.instabug.crash.nonFatals.ignorenonfatalsvalidation

import com.instabug.crash.Constants
import com.instabug.library.util.InstabugSDKLogger
import java.util.regex.Pattern
import java.util.regex.PatternSyntaxException

object NonFatalMessageRegexValidator {
    fun matchIgnoreNonFatalRegexWithActualMessage(emRegex: String, message: String): Boolean {
        return try {
            val pattern = Pattern.compile(emRegex)
            val matcher = pattern.matcher(message)
            matcher.find()
        } catch (e: PatternSyntaxException) {
            InstabugSDKLogger.w(
                Constants.LOG_TAG,
                "Invalid non-fatal filtering rule invalid regex $emRegex ) " + e.message
            )
            false
        }
    }
}
