package com.instabug.bganr

import androidx.annotation.WorkerThread
import com.instabug.commons.caching.FileCacheDirectory
import com.instabug.commons.caching.SessionCacheDirectory
import com.instabug.commons.snapshot.ifNotExists
import java.io.File

class BackgroundAnrCacheDir(
    private val parentDir: SessionCacheDirectory
) : FileCacheDirectory {
    override val fileDirectory: File?
        @WorkerThread get() = parentDir.currentSessionDirectory?.let(::getBackgroundAnrDir)

    companion object {
        private const val BG_ANR_DIR_NAME = "bg_anr"
        private const val BASELINE_TRACE_FILE = "trace-bl.txt"
        const val VALIDATED_TRACE_FILE = "trace-vld.txt"
        const val MIGRATED_TRACE_FILE = "trace-mig.txt"

        private fun getBackgroundAnrDir(sessionDir: File): File =
            sessionDir.run { File("$absolutePath${File.separator}$BG_ANR_DIR_NAME") }

        fun searchForBackgroundAnrDir(sessionDir: File): File? =
            sessionDir.listFiles { file -> file.isDirectory && file.name == BG_ANR_DIR_NAME }
                ?.firstOrNull()

        fun createTraceBaselineFile(sessionDir: File): File =
            getBackgroundAnrDir(sessionDir)
                .ifNotExists { mkdirs() }
                .run { File("$absolutePath${File.separator}$BASELINE_TRACE_FILE") }
                .ifNotExists { createNewFile() }

        fun searchForTraceBaselineFile(sessionDir: File): File? =
            searchForBackgroundAnrDir(sessionDir)
                ?.listFiles { file -> file.name == BASELINE_TRACE_FILE }
                ?.firstOrNull()

        fun searchForValidatedTraceFile(sessionDir: File): File? =
            searchForBackgroundAnrDir(sessionDir)
                ?.listFiles { file -> file.name == VALIDATED_TRACE_FILE }
                ?.firstOrNull()

        fun searchForMigratedTraceFile(sessionDir: File): File? =
            searchForBackgroundAnrDir(sessionDir)
                ?.listFiles { file -> file.name == MIGRATED_TRACE_FILE }
                ?.firstOrNull()
    }
}