package com.instabug.crash.configurations

interface CrashConfigurationProvider {

    /**
     * References local state of crash reporting
     */
    var crashReportingLocallyEnabled: Boolean

    /**
     * References crash reporting feature availability
     */
    var isCrashReportingAvailable: Boolean

    var isCrashMetaDataCallbackEnabled: Boolean

    var isNonFatalReportingAvailable: Boolean

    var isMetadataImmediateSyncAvailable: Boolean
    /**
     * Gets the currents state of crash reporting
     * @return true if @{link isCrashReportingAvailable} = true and {@link crashReportingLocallyEnabled} = true
     * False otherwise
     */
    fun isCrashReportingEnabled(): Boolean

    /**
     * Gets the current state of Non fatal reporting
     * returns if @link {isNonFatalReportingAvailable} = true and
     * @{link isCrashReportingAvailable} = true and
     * {@link crashReportingLocallyEnabled} = true False otherwise
     */
    fun isNonFatalReportingEnabled(): Boolean
}
