package com.instabug.commons.utils

import com.instabug.anr.di.AnrServiceLocator
import com.instabug.commons.configurations.ConfigurationsProvider
import com.instabug.commons.di.CommonsLocator
import com.instabug.crash.di.CrashesServiceLocator
import com.instabug.fatalhangs.di.FatalHangsServiceLocator
import com.instabug.library.IssueType
import com.instabug.library.ReproMode
import com.instabug.library.visualusersteps.ReproConfigurationsProvider
import com.instabug.terminations.di.ServiceLocator

fun getReproConfigurationProviderForCrashType(issueType: @IssueType Int): ReproConfigurationsProvider? =
    when(issueType) {
        IssueType.Fatal -> CommonsLocator.configurationsProvider
        IssueType.NonFatal -> CrashesServiceLocator.nonFatalsConfigurationsProvider
        IssueType.ForceRestart -> ServiceLocator.terminationsConfigurationProvider
        IssueType.AppHang -> FatalHangsServiceLocator.reproConfigurationsProvider
        IssueType.ANR -> AnrServiceLocator.anrConfigurationProvider
        else -> null
    }

fun ReproConfigurationsProvider?.getReproMode(): @ReproMode Int =
    this?.let { configProvider ->
        when {
            configProvider.isReproScreenshotsEnabled -> ReproMode.EnableWithScreenshots
            configProvider.isReproStepsEnabled -> ReproMode.EnableWithNoScreenshots
            else -> ReproMode.Disable
        }
    } ?: ReproMode.Disable
