package com.instabug.commons.di

import android.content.Context
import android.os.Process
import androidx.annotation.VisibleForTesting
import com.instabug.commons.DefaultDetectorsListenersRegistry
import com.instabug.commons.IncidentDetectorsListenersRegistry
import com.instabug.commons.caching.CrashesCacheDir
import com.instabug.commons.caching.SessionCacheDirectory
import com.instabug.commons.configurations.CommonCrashesConfigurationsHandler
import com.instabug.commons.configurations.CommonCrashesConfigurationsProvider
import com.instabug.commons.configurations.CompositeConfigurationsHandler
import com.instabug.commons.configurations.ConfigurationsProvider
import com.instabug.commons.lifecycle.CompositeLifecycleOwner
import com.instabug.commons.metadata.CrashMetadataMapper
import com.instabug.commons.metadata.CrashMetadataMapperImpl
import com.instabug.commons.metadata.OnCrashSentCallbackWrapper
import com.instabug.commons.session.CrashesSessionsDataController
import com.instabug.commons.session.DefaultSessionIncidentCachingHandler
import com.instabug.commons.session.DefaultSessionLinker
import com.instabug.commons.session.SessionIncidentCachingHandler
import com.instabug.commons.session.SessionLinker
import com.instabug.commons.snapshot.CaptorsRegistry
import com.instabug.commons.threading.ThreadingLimitsProvider
import com.instabug.commons.threading.ThreadingLimitsProviderImpl
import com.instabug.crash.OnCrashSentCallback
import com.instabug.library.AppLaunchIDProvider
import com.instabug.library.Instabug
import com.instabug.library.IssueType
import com.instabug.library.SpanIDProvider
import com.instabug.library.WatchableSpansCacheDirectory
import com.instabug.library.core.InstabugCore
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.internal.storage.AttachmentManager
import com.instabug.library.screenshot.analytics.ProductAnalyticsCollector
import com.instabug.library.sessionV3.configurations.IBGSessionCrashesConfigurations
import com.instabug.library.sessionV3.providers.FeatureSessionDataController
import com.instabug.library.util.threading.OrderedExecutorService
import com.instabug.library.util.threading.PoolProvider
import com.instabug.library.util.threading.PriorityThreadFactory
import com.instabug.library.visualusersteps.BasicReproRuntimeConfigurationsHandler
import com.instabug.library.visualusersteps.ReproCapturingProxy
import java.util.concurrent.Executors
import java.util.concurrent.ScheduledExecutorService

object CommonsLocator {
    @JvmStatic
    val sessionLinker: SessionLinker by lazy { DefaultSessionLinker() }

    val sessionIncidentCachingHandler: SessionIncidentCachingHandler
            by lazy { DefaultSessionIncidentCachingHandler() }

    val sessionCrashesConfigurations: IBGSessionCrashesConfigurations
        get() = InstabugCore.getV3SessionCrashesConfigurations()

    @JvmStatic
    val crashesSessionDataController: FeatureSessionDataController
        get() = CrashesSessionsDataController

    val captorsRegistry: CaptorsRegistry by lazy { CaptorsRegistry() }
        @JvmStatic get

    private val orderedExecutor: OrderedExecutorService
        get() = PoolProvider.getInstance().orderedExecutor

    val crashesCacheDir: SessionCacheDirectory
            by lazy {
                CrashesCacheDir(
                    orderedExecutor,
                    { ctx },
                    { AttachmentManager.getAttachmentInternalDirectory(it) },
                    { AttachmentManager.getAttachmentDirectory(it) }
                )
            }
        @JvmStatic get

    val compositeLifecycleOwner: CompositeLifecycleOwner
            by lazy { CompositeLifecycleOwner(PoolProvider.getInstance().scheduledExecutor) }
    val ctx: Context?
        get() = Instabug.getApplicationContext()
    val detectorsListenersRegistry: IncidentDetectorsListenersRegistry
            by lazy { DefaultDetectorsListenersRegistry() }
    val appCtx: Context?
        get() = Instabug.getApplicationContext()

    @VisibleForTesting
    val reproConfigHandlerDelegate: BasicReproRuntimeConfigurationsHandler by lazy {
        BasicReproRuntimeConfigurationsHandler(IssueType.Fatal, configurationsProvider)
    }

    val configurationsHandler: CompositeConfigurationsHandler by lazy {
        CommonCrashesConfigurationsHandler(configurationsProvider, reproConfigHandlerDelegate)
    }

    @JvmStatic
    val configurationsProvider: ConfigurationsProvider
            by lazy { CommonCrashesConfigurationsProvider() }

    val reproProxy: ReproCapturingProxy
        get() = CoreServiceLocator.reproCompositeProxy

    val reproScreenshotsCacheDir: WatchableSpansCacheDirectory
        get() = CoreServiceLocator.reproScreenshotsCacheDir

    val appLaunchIdProvider: SpanIDProvider
        get() = AppLaunchIDProvider

    fun getCoreScheduler(): ScheduledExecutorService =
        PoolProvider.getInstance().scheduledExecutor

    @JvmStatic
    var userCrashMetadataCallback: OnCrashSentCallback? = null

    @JvmStatic
    val crashMetadataCallback: OnCrashSentCallback by lazy { OnCrashSentCallbackWrapper }

    @JvmStatic
    val crashMetadataMapper: CrashMetadataMapper by lazy { CrashMetadataMapperImpl() }

    @JvmStatic
    val threadingLimitsProvider: ThreadingLimitsProvider by lazy {
        ThreadingLimitsProviderImpl(
            CoreServiceLocator.getLimitConstraintApplier()
        )
    }

    @JvmStatic
    val crashReportingProductAnalyticsCollector: ProductAnalyticsCollector by lazy {
        ProductAnalyticsCollector(
            CoreServiceLocator.commonAnalyticsCollector,
            configurationsProvider
        )
    }
}
