package com.instabug.anr.di

import android.os.Build
import androidx.annotation.RequiresApi
import com.instabug.anr.configuration.AnrConfigurationHandlerImpl
import com.instabug.anr.configuration.AnrConfigurationProvider
import com.instabug.anr.configuration.AnrConfigurationProviderImpl
import com.instabug.anr.early_anr.EarlyAnrMigrator
import com.instabug.anr.early_anr.IEarlyAnrMigrator
import com.instabug.commons.DefaultOSExitInfoExtractor
import com.instabug.commons.IncidentDetectorsListener
import com.instabug.commons.configurations.ConfigurationsHandler
import com.instabug.commons.di.CommonsLocator
import com.instabug.library.SpansCacheDirectory
import com.instabug.library.visualusersteps.ReproConfigurationsProvider


object AnrServiceLocator {

    val anrConfigurationHandler: ConfigurationsHandler by lazy {
        AnrConfigurationHandlerImpl()
    }

    @JvmStatic
    val anrConfigurationProvider: AnrConfigurationProvider by lazy {
        AnrConfigurationProviderImpl()
    }

    @JvmStatic
    val anrDetectorListener: IncidentDetectorsListener
        get() = CommonsLocator.detectorsListenersRegistry

    val reproConfigurationsProvider: ReproConfigurationsProvider
        @JvmStatic get() = anrConfigurationProvider

    val reproScreenshotsCacheDir: SpansCacheDirectory
        @JvmStatic get() = CommonsLocator.reproScreenshotsCacheDir

    val earlyAnrMigrator: IEarlyAnrMigrator
        @RequiresApi(Build.VERSION_CODES.R)
        get() = EarlyAnrMigrator(anrConfigurationProvider, DefaultOSExitInfoExtractor())

}
