/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.commons.caching;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.ProcessedUri;
import com.instabug.library.util.FileUtils;
import com.instabug.library.visualusersteps.VisualUserStepsHelper;
import java.io.File;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class DiskHelper {
    @NotNull
    public static final DiskHelper INSTANCE = new DiskHelper();

    private DiskHelper() {
    }

    @JvmStatic
    @NotNull
    public static final File getCrashesInternalDirectory(@NotNull Context ctx) {
        Object object;
        File file;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        File file2 = file;
        object = new File(DiskUtils.getInstabugInternalDirectory((Context)object), "crash-reports").exists() ? file2 : null;
        if (object == null) {
            file2.mkdirs();
        }
        INSTANCE.createNoMediaFile(file2);
        return file2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void createNoMediaFile(File parentDir) {
        block6: {
            File file;
            File file2;
            // empty try
            File file3 = file2;
            file = new File(file, ".nomedia").exists() ? file3 : null;
            if (file != null) break block6;
            file3.createNewFile();
            // empty try
        }
        try {
            Result.constructor-impl((Object)file3);
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final File getIncidentSavingDirectory(@NotNull Context ctx, @NotNull String prefix, @NotNull String incidentId) {
        void var2_2;
        void var1_1;
        Context context;
        Intrinsics.checkNotNullParameter((Object)context, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)incidentId, (String)"incidentId");
        return new File(DiskHelper.getCrashesInternalDirectory(context), (String)var1_1 + '_' + (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final File getIncidentStateFile(@NotNull File savingDir, @NotNull String prefix) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter((Object)file, (String)"savingDir");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return new File(file, (String)var1_1 + '_' + System.currentTimeMillis() + ".txt");
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @WorkerThread
    @NotNull
    public static final Pair<String, Boolean> getReproScreenshotsZipPath(@NotNull Context ctx, @NotNull String incidentId, @NotNull File savingDir, @NotNull File screenshotsDir) {
        Object object;
        void var2_2;
        ProcessedUri processedUri;
        Context context;
        Intrinsics.checkNotNullParameter((Object)context, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)processedUri, (String)"incidentId");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"savingDir");
        Intrinsics.checkNotNullParameter((Object)object, (String)"screenshotsDir");
        processedUri = VisualUserStepsHelper.getVisualUserStepsFile((Context)ctx, (String)processedUri, (File)object);
        object = processedUri.getUri();
        object = object == null ? null : object.getPath();
        return TuplesKt.to((Object)FileUtils.copyAndDeleteOriginalFile((Context)context, (String)object, (String)Intrinsics.stringPlus((String)var2_2.getAbsolutePath(), (Object)"/")), (Object)processedUri.isUriEncrypted());
    }
}

