/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.commons.snapshot;

import android.content.Context;
import com.instabug.commons.caching.SessionCacheDirectory;
import com.instabug.commons.di.CommonsLocator;
import com.instabug.commons.lifecycle.b;
import com.instabug.commons.lifecycle.c;
import com.instabug.commons.logging.a;
import com.instabug.commons.snapshot.FileKtxKt;
import com.instabug.commons.snapshot.d;
import com.instabug.commons.snapshot.e;
import com.instabug.library.model.State;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StateSnapshotCaptor
extends d
implements b {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int ID = 1;
    @NotNull
    public static final String STATE_SNAPSHOT_FILE_NAME = "snapshot";
    @NotNull
    public static final String OLD_STATE_SNAPSHOT_FILE_SUFFIX = "-old";
    @NotNull
    private static final String CAPTOR_NAME = "CrashesStateSnapshot";
    @NotNull
    private final e configurations;
    @NotNull
    private final c lifecycleOwner;

    /*
     * WARNING - void declaration
     */
    public StateSnapshotCaptor(@NotNull e configurations, @NotNull c lifecycleOwner) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"lifecycleOwner");
        super(var1_1.b());
        this.configurations = var1_1;
        this.lifecycleOwner = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final File getSnapshotFile(File $this$snapshotFile) {
        void var1_1;
        return new File(var1_1.getAbsolutePath() + File.separator + STATE_SNAPSHOT_FILE_NAME);
    }

    /*
     * WARNING - void declaration
     */
    private final File getOldSnapshotFile(File $this$oldSnapshotFile) {
        void var1_1;
        return new File(Intrinsics.stringPlus((String)var1_1.getAbsolutePath(), (Object)OLD_STATE_SNAPSHOT_FILE_SUFFIX));
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    @NotNull
    protected String getCaptorName() {
        return CAPTOR_NAME;
    }

    @Override
    protected long getCapturingPeriod() {
        return 5L;
    }

    @Override
    protected void onStart() {
        this.lifecycleOwner.a(this);
    }

    @Override
    protected void onShutdown() {
        this.lifecycleOwner.b(this);
    }

    @Override
    protected void capture() {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        File file = stateSnapshotCaptor2.configurations.c();
        if (file != null) {
            File file2;
            File file3 = stateSnapshotCaptor2.getSnapshotFile(file);
            if (!file3.exists()) {
                file3 = null;
            }
            if (file3 == null) {
                file3 = null;
            } else {
                File file4 = file3;
                file3 = stateSnapshotCaptor2.getOldSnapshotFile(file3);
                file4.renameTo(file3);
            }
            File file5 = stateSnapshotCaptor2.getSnapshotFile(file).getParentFile();
            if (file5 != null && (file2 = file5.exists() ? file5 : null) == null) {
                file5.mkdirs();
            }
            if ((file5 = stateSnapshotCaptor2.configurations.a()) != null) {
                StateSnapshotCaptor stateSnapshotCaptor = stateSnapshotCaptor2;
                StateSnapshotCaptor stateSnapshotCaptor2 = new State.Builder((Context)file5).withCurrentActivity(true).build(true, true, 1.0f);
                stateSnapshotCaptor2.updateVisualUserSteps();
                File file6 = stateSnapshotCaptor.getSnapshotFile(file);
                StateSnapshotCaptor stateSnapshotCaptor3 = stateSnapshotCaptor2;
                Intrinsics.checkNotNullExpressionValue((Object)stateSnapshotCaptor3, (String)"savable");
                FileKtxKt.writeSerializable(file6, (Serializable)((Object)stateSnapshotCaptor3));
            }
            if (file3 != null) {
                file3.delete();
            }
            a.b("State snapshot captured");
        }
    }

    public void onActivityStarted() {
        a.b("StateSnapshotCaptor: Activity started");
        this.force();
    }

    public void onFragmentStarted() {
        a.b("StateSnapshotCaptor: Fragment started");
        this.force();
    }

    public void onBackgrounded() {
        a.b("StateSnapshotCaptor: Backgrounded");
    }

    public static final class Factory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final StateSnapshotCaptor invoke(@NotNull Function0<? extends Context> ctxGetter, @NotNull Function0<? extends File> savingDirectoryGetter, @NotNull Function1<? super String, ? extends ScheduledExecutorService> executorFactory, @NotNull c lifecycleOwner) {
            void var3_3;
            e e2;
            void var2_2;
            void var1_1;
            Function0<? extends Context> function0;
            Intrinsics.checkNotNullParameter(function0, (String)"ctxGetter");
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"savingDirectoryGetter");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"executorFactory");
            Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
            e e3 = e2;
            e2 = new e(function0, (Function0)var1_1, (Function1)var2_2);
            return new StateSnapshotCaptor(e3, (c)var3_3);
        }

        public static /* synthetic */ StateSnapshotCaptor invoke$default(Function0 object, Function0 object2, Function1 function1, c c2, int n2, Object object3) {
            if ((n2 & 1) != 0) {
                PropertyReference0Impl propertyReference0Impl;
                object = propertyReference0Impl;
                propertyReference0Impl = new PropertyReference0Impl(CommonsLocator.INSTANCE){

                    @Nullable
                    public Object get() {
                        return ((CommonsLocator)this.receiver).getAppCtx();
                    }
                };
            }
            if ((n2 & 2) != 0) {
                PropertyReference0Impl propertyReference0Impl;
                object2 = propertyReference0Impl;
                propertyReference0Impl = new PropertyReference0Impl(CommonsLocator.getCrashesCacheDir()){

                    @Nullable
                    public Object get() {
                        return ((SessionCacheDirectory)this.receiver).getCurrentSessionDirectory();
                    }
                };
            }
            if ((n2 & 4) != 0) {
                Function1 function12;
                function1 = function12;
                function12 = new Function1(CommonsLocator.INSTANCE){

                    @NotNull
                    public final ScheduledExecutorService a(@NotNull String string) {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"p0");
                        return ((CommonsLocator)this.receiver).getScheduledExecutor(string);
                    }
                };
            }
            if ((n2 & 8) != 0) {
                c2 = CommonsLocator.INSTANCE.getCompositeLifecycleOwner();
            }
            return Factory.invoke((Function0<? extends Context>)object, (Function0<? extends File>)object2, (Function1<? super String, ? extends ScheduledExecutorService>)function1, c2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final StateSnapshotCaptor invoke(@NotNull Function0<? extends Context> ctxGetter, @NotNull Function0<? extends File> savingDirectoryGetter, @NotNull Function1<? super String, ? extends ScheduledExecutorService> executorFactory) {
            void var2_2;
            void var1_1;
            Function0<? extends Context> function0;
            Intrinsics.checkNotNullParameter(function0, (String)"ctxGetter");
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"savingDirectoryGetter");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"executorFactory");
            return Factory.invoke$default(ctxGetter, (Function0)var1_1, (Function1)var2_2, null, 8, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final StateSnapshotCaptor invoke(@NotNull Function0<? extends Context> ctxGetter, @NotNull Function0<? extends File> savingDirectoryGetter) {
            Function0<? extends Context> function0;
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter(function0, (String)"ctxGetter");
            Intrinsics.checkNotNullParameter((Object)v0, (String)"savingDirectoryGetter");
            return Factory.invoke$default(ctxGetter, (Function0)v0, null, null, 12, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final StateSnapshotCaptor invoke(@NotNull Function0<? extends Context> ctxGetter) {
            Function0<? extends Context> function0 = ctxGetter;
            Intrinsics.checkNotNullParameter(function0, (String)"ctxGetter");
            return Factory.invoke$default(function0, null, null, null, 14, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final StateSnapshotCaptor invoke() {
            return Factory.invoke$default(null, null, null, null, 15, null);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final File getSnapshotFile(@NotNull File sessionDirectory) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sessionDirectory, (String)"sessionDirectory");
            return new File(var1_1.getAbsolutePath() + File.separator + StateSnapshotCaptor.STATE_SNAPSHOT_FILE_NAME);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final File getOldSnapshotFile(@NotNull File sessionDirectory) {
            void var1_1;
            void v0 = var1_1;
            Intrinsics.checkNotNullParameter((Object)v0, (String)"sessionDirectory");
            File this_ = ((Companion)((Object)this_)).getSnapshotFile((File)v0);
            return new File(Intrinsics.stringPlus((String)this_.getAbsolutePath(), (Object)StateSnapshotCaptor.OLD_STATE_SNAPSHOT_FILE_SUFFIX));
        }
    }
}

