/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.crash;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.crash.eventbus.NDKCrashReportingFeatureStateChange;
import com.instabug.crash.models.a;
import com.instabug.crash.screenrecording.a;
import com.instabug.crash.utils.e;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventPublisher;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.WriteStateToFileDiskOperation;
import com.instabug.library.internal.video.ScreenRecordingService;
import com.instabug.library.model.Report;
import com.instabug.library.model.State;
import com.instabug.library.model.UserAttributes;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ReportHelper;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.util.threading.ThreadUtils;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CrashReporting {
    private static final String TAG = "CrashReporting";
    public static final String CRASH_STATE = "crash_state";
    public static final String ANR_STATE = "anr_state";

    public static void reportException(@NonNull Throwable throwable) {
        VoidRunnable voidRunnable;
        Throwable throwable2;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("Reporting handled exception: " + throwable2.getMessage()));
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (throwable2 == null) {
                    return;
                }
                if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
                    InstabugSDKLogger.e((String)"IBG-CR", (String)"CrashReporting is disabled, Couldn't report error");
                    return;
                }
                CrashReporting.access$000(throwable2, null);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.reportException", (VoidRunnable)voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    private static void createFormattedException(@NonNull Throwable throwable, @Nullable String identifier) {
        void var1_1;
        CrashReporting.createFormattedException(throwable, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void createFormattedException(@NonNull Throwable throwable, @Nullable String identifier, @Nullable Map<String, String> userAttributes) {
        void var1_2;
        JSONObject jSONObject;
        String string;
        if (throwable == null) {
            return;
        }
        InstabugSDKLogger.v((String)"IBG-CR", (String)("Creating formatted exception for error: " + string.getClass().getCanonicalName()));
        JSONObject jSONObject2 = jSONObject;
        Throwable throwable2 = string;
        jSONObject2();
        string = "error";
        jSONObject.put(string, (Object)e.a(throwable2, (String)var1_2));
        try {
            void var2_3;
            CrashReporting.reportException(jSONObject, true, (Map<String, String>)var2_3);
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"Error while creating formatted exception ", (Throwable)jSONException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void reportException(@NonNull JSONObject jsonObject, boolean isHandled) {
        void var1_1;
        CrashReporting.reportException(jsonObject, (boolean)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void reportException(@NonNull JSONObject jsonObject, boolean isHandled, @Nullable Map<String, String> userAttributes) {
        void var2_2;
        JSONObject jSONObject;
        void var1_1;
        if (jsonObject == null) {
            return;
        }
        if (InstabugCore.getPlatform() != 2 && var1_1 == false) {
            CrashReporting.reportCrashingSession();
        }
        if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
            return;
        }
        if (a.a().isEnabled() && SettingsManager.getInstance().autoScreenRecordingEnabled()) {
            CrashReporting.deleteAutoScreenRecording();
        }
        PoolProvider.getSingleThreadExecutor((String)"HANDLED_CRASH").execute(new Runnable((boolean)var1_1, (Map)var2_2){
            final /* synthetic */ boolean b;
            final /* synthetic */ Map c;
            {
                this.b = bl;
                this.c = map;
            }

            @Override
            public void run() {
                Context context = Instabug.getApplicationContext();
                if (context == null) {
                    return;
                }
                b b2 = this;
                State state = State.getState((Context)context);
                com.instabug.crash.utils.b.a(state);
                Object object = ReportHelper.getReport((Report.OnReportCreatedListener)InstabugCore.getOnReportCreatedListener());
                com.instabug.crash.models.a a2 = CrashReporting.getCrash(b2.jSONObject, this.b, state);
                ReportHelper.update((State)a2.f(), (Report)object);
                object = b2.c;
                if (object != null && !object.isEmpty()) {
                    CrashReporting.access$100(state, this.c);
                }
                if (InstabugCore.getExtraAttachmentFiles() != null && InstabugCore.getExtraAttachmentFiles().size() >= 1) {
                    CrashReporting.addCrashAttachments(context, a2);
                }
                CrashReporting.access$200(context, a2, DiskUtils.createStateTextFile((Context)context, (String)CrashReporting.CRASH_STATE));
                com.instabug.crash.cache.b.b(a2);
                InstabugSDKLogger.d((String)"IBG-CR", (String)"Your exception has been reported");
                com.instabug.crash.network.b.b().start();
                a.a().b();
            }
        });
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void appendUserAttributes(@NonNull State state, Map<String, String> userAttributesMap) {
        var2_2 = 90;
        var3_3 = 100;
        var4_5 = "Instabug-CrashReporting";
        var5_6 = v0;
        v0 = new UserAttributes();
        try {
            ** if (state.getUserAttributes() == null) goto lbl-1000
        }
        catch (JSONException var6_8) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"Error while appending user attributes to crash report", (Throwable)var6_8);
        }
lbl-1000:
        // 1 sources

        {
            var6_7 = v1;
            var7_9 = new JSONObject(var0.getUserAttributes()).keys();
            while (true) {
                ** if (!var7_9.hasNext()) goto lbl22
lbl-1000:
                // 1 sources

                {
                    v2 = var5_6;
                    v3 /* !! */  = var6_7;
                    var8_10 = (String)var7_9.next();
                    v2.put(var8_10, v3 /* !! */ .getString(var8_10));
                    continue;
                }
lbl22:
                // 1 sources

                ** GOTO lbl26
                break;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
lbl26:
        // 3 sources

        if (var1_1.size() > var3_3) {
            Log.w((String)var4_5, (String)("Some old user attributes were removed. Max allowed user attributes reached. Please note that you can add up to " + var3_3 + " user attributes."));
            var6_7 = v4;
            v4 = new LinkedHashMap<K, V>(var1_1);
            var7_9 = var1_1.entrySet().iterator();
            while (var7_9.hasNext()) {
                v5 = var6_7;
                v5.remove(var7_9.next().getKey());
                if (v5.size() > var3_3) continue;
            }
            v6 = var1_1;
            v6.clear();
            v6.putAll(var6_7);
        }
        for (Object var6_7 : var1_1.entrySet()) {
            if (var1_1.get(var6_7.getKey()) == null) continue;
            if (((String)var6_7.getKey()).length() <= var2_2 && ((String)var6_7.getValue()).length() <= var2_2) {
                var5_6.put((String)var6_7.getKey(), (String)var6_7.getValue());
                continue;
            }
            Log.w((String)var4_5, (String)("Some user attributes weren't added. Max allowed user attributes characters limit is reached. Please note that you can add user attributes (key, value) with characters count up to " + var2_2 + " characters."));
        }
        var0.setUserAttributes(var5_6.toString());
    }

    private static void reportCrashingSession() {
        InstabugSDKLogger.d((String)"IBG-CR", (String)"Report crashing session");
        SDKCoreEventPublisher.post((SDKCoreEvent)new SDKCoreEvent("cross_platform_crashed"));
        com.instabug.crash.settings.d.a().a(true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createStateTextFile(@NonNull Context context, @NonNull com.instabug.crash.models.a crash, @NonNull File file) {
        void var1_2;
        if (file == null) return;
        if (var1_2 == null) return;
        if (var1_2.f() == null) {
            return;
        }
        InstabugSDKLogger.v((String)"IBG-CR", (String)("Creating state file for crash: " + var1_2.d()));
        try {
            void var2_3;
            Context context2;
            context2 = DiskUtils.with((Context)context2).writeOperation((DiskOperation)new WriteStateToFileDiskOperation((File)var2_3, var1_2.f().toJson())).execute();
            if (context2 != null) {
                var1_2.f().setUri((Uri)context2);
            }
            AttachmentsUtility.encryptAttachments(var1_2.a());
            return;
        }
        catch (Throwable throwable) {
            InstabugSDKLogger.e((String)"IBG-CR", (String)"error while creating state text file", (Throwable)throwable);
        }
    }

    public static void deleteAutoScreenRecording() {
        AutoScreenRecordingEventBus.getInstance().post((Object)ScreenRecordingService.Action.STOP_DELETE);
    }

    /*
     * WARNING - void declaration
     */
    public static void addCrashAttachments(@NonNull Context context, com.instabug.crash.models.a crash) {
        void var1_1;
        if (context != null && var1_1 != null) {
            if (InstabugCore.getExtraAttachmentFiles() != null) {
                for (Map.Entry entry : InstabugCore.getExtraAttachmentFiles().entrySet()) {
                    Context context2;
                    Uri uri = AttachmentsUtility.getNewFileAttachmentUri((Context)context2, (Uri)((Uri)entry.getKey()), (String)((String)entry.getValue()));
                    if (uri == null) continue;
                    var1_1.a(uri);
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static com.instabug.crash.models.a getCrash(JSONObject jsonObject, boolean handled, State state) {
        void var1_2;
        JSONObject jSONObject;
        com.instabug.crash.models.a a2;
        com.instabug.crash.models.a a3 = a2 = new a.b().a((State)a2);
        a3.a(jSONObject.toString());
        a3.a(a.a.READY_TO_BE_SENT);
        a2.a((boolean)var1_2);
        try {
            a2.d(ThreadUtils.getThreadsData(null).toString());
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e((String)"Failed to get threads details", (String)jSONException.toString(), (Throwable)jSONException);
        }
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    public static void reportException(@NonNull Throwable throwable, @Nullable String exceptionIdentifier) {
        void var1_1;
        Throwable throwable2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string;
            }

            public void run() {
                CrashReporting.reportException(throwable2, this.b, null);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.reportException", (VoidRunnable)voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    public static void reportException(@NonNull Throwable throwable, @Nullable String exceptionIdentifier, @Nullable Map<String, String> userAttributes) {
        void var2_2;
        void var1_1;
        Throwable throwable2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1, (Map)var2_2){
            final /* synthetic */ String b;
            final /* synthetic */ Map c;
            {
                this.b = string;
                this.c = map;
            }

            public void run() {
                if (string.throwable2 == null) {
                    return;
                }
                if (InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
                    return;
                }
                d d2 = string;
                String string = d2.b;
                CrashReporting.access$300(string.throwable2, string, d2.c);
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.reportException", (VoidRunnable)voidRunnable2);
    }

    private static void reportUncaughtException(@NonNull JSONObject jsonObject) {
        JSONObject jSONObject;
        if (jsonObject == null) {
            return;
        }
        CrashReporting.reportException(jSONObject, false);
    }

    public static void setState(@NonNull Feature.State state) {
        VoidRunnable voidRunnable;
        Feature.State state2;
        InstabugSDKLogger.d((String)"IBG-CR", (String)("CrashReporting setState:" + state2));
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (state2 == Feature.State.ENABLED && !InstabugCore.isFeatureAvailable((Feature)Feature.CRASH_REPORTING)) {
                    InstabugSDKLogger.e((String)"Instabug-CrashReporting", (String)"crash reporting wasn't enabled as it seems to be disabled for your Instabug company account. Please, contact support to switch it on for you.");
                    return;
                }
                InstabugCore.setFeatureState((Feature)Feature.CRASH_REPORTING, (Feature.State)state2);
                SDKCoreEventPublisher.post((SDKCoreEvent)new SDKCoreEvent("features", "updated"));
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.setState", (VoidRunnable)voidRunnable2);
    }

    public static void setAnrState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (state2 == Feature.State.ENABLED && InstabugCore.getFeatureState((Feature)Feature.CRASH_REPORTING) == Feature.State.DISABLED) {
                    InstabugSDKLogger.w((String)"IBG-CR", (String)"Can not enable ANR reporting while Crash reporting is disabled");
                    return;
                }
                InstabugCore.setFeatureState((Feature)Feature.ANR_REPORTING, (Feature.State)state2);
                SDKCoreEventPublisher.post((SDKCoreEvent)new SDKCoreEvent("features", "updated"));
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.setAnrState", (VoidRunnable)voidRunnable2);
    }

    public static void setNDKCrashesState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            public void run() {
                if (NDKCrashReportingFeatureStateChange.getInstance() != null) {
                    NDKCrashReportingFeatureStateChange.getInstance().post(state2);
                } else {
                    InstabugSDKLogger.e((String)"IBG-CR", (String)"Couldn't not enable NDK crash reporting state is null.");
                }
            }
        };
        APIChecker.checkAndRunInExecutor((String)"CrashReporting.setNDKCrashesState", (VoidRunnable)voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Throwable x0, String x1) {
        void var1_1;
        CrashReporting.createFormattedException(x0, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(State x0, Map x1) {
        void var1_1;
        CrashReporting.appendUserAttributes(x0, (Map<String, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Context x0, com.instabug.crash.models.a x1, File x2) {
        void var2_2;
        void var1_1;
        CrashReporting.createStateTextFile(x0, (com.instabug.crash.models.a)var1_1, (File)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(Throwable x0, String x1, Map x2) {
        void var2_2;
        void var1_1;
        CrashReporting.createFormattedException(x0, (String)var1_1, (Map<String, String>)var2_2);
    }
}

