/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.screenshot.viewhierarchy.utilities;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.instabug.bug.screenshot.viewhierarchy.b;
import com.instabug.bug.screenshot.viewhierarchy.c;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ViewHierarchyDiskUtils {
    private static final String TAG = "ViewHierarchyDiskUtils";

    public static void saveViewHierarchyImage(b viewHierarchy) {
        File file = new File(ViewHierarchyDiskUtils.getViewHierarchyImagesDirectory(viewHierarchy.o().getContext()).getAbsolutePath() + File.separator + viewHierarchy.a() + ".png");
        try {
            if (viewHierarchy.j() != null) {
                DiskUtils.saveBitmapOnDisk((Bitmap)viewHierarchy.j(), (File)file);
                viewHierarchy.a(Uri.fromFile((File)file));
            } else {
                InstabugSDKLogger.d((Object)TAG, (String)("trying to save a null value bitmap, time in MS: " + System.currentTimeMillis()));
            }
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e((Object)TAG, (String)("save viewHierarchy image got error: " + iOException.getMessage() + ", time in MS: " + System.currentTimeMillis()), (Throwable)iOException);
        }
    }

    @Nullable
    public static synchronized Uri zipViewHierarchyImages(b viewHierarchy) {
        InstabugSDKLogger.d((Object)TAG, (String)("zip viewHierarchy images just started, time in MS: " + System.currentTimeMillis()));
        try {
            File file = new File(DiskUtils.getInstabugDirectory((Context)viewHierarchy.o().getContext()) + File.separator + "view_hierarchy_attachment_" + System.currentTimeMillis() + ".zip");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (b b2 : c.b(viewHierarchy)) {
                if (b2.l() == null) continue;
                File file2 = new File(b2.l().getPath());
                zipOutputStream.putNextEntry(new ZipEntry(b2.a() + ".png"));
                ViewHierarchyDiskUtils.copy(file2, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
                if (!file2.delete()) continue;
                InstabugSDKLogger.d((Object)TAG, (String)("file zipped successfully, path: " + file2.getPath() + ", time in MS: " + System.currentTimeMillis()));
            }
            if (file.length() != 0L) {
                zipOutputStream.close();
            }
            InstabugSDKLogger.d((Object)TAG, (String)("zip viewHierarchy images done successfully, path: " + file.getPath() + ", time in MS: " + System.currentTimeMillis()));
            return Uri.fromFile((File)file);
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e((Object)TAG, (String)("zip viewHierarchy images got error: " + iOException.getMessage() + ", time in MS: " + System.currentTimeMillis()), (Throwable)iOException);
            return null;
        }
    }

    private static void copy(File file, OutputStream out) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ViewHierarchyDiskUtils.copy(fileInputStream, out);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = in.read(byArray)) >= 0) {
            out.write(byArray, 0, n);
        }
    }

    public static File getViewHierarchyImagesDirectory(Context context) {
        String string = DiskUtils.getInstabugDirectory((Context)context) + "/view-hierarchy-images/";
        File file = new File(string);
        if (!file.exists() && file.mkdir()) {
            InstabugSDKLogger.d((Object)TAG, (String)("temp directory created successfully: " + file.getPath() + ", time in MS: " + System.currentTimeMillis()));
        }
        return file;
    }
}

