/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.cache;

import android.support.annotation.Nullable;
import com.instabug.bug.model.Bug;
import com.instabug.bug.network.c;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;

public class BugsCacheManager {
    public static final String BUGS_DISK_CACHE_KEY = "bugs_disk_cache";
    public static final String BUGS_MEMORY_CACHE_KEY = "bugs_memory_cache";
    public static final String BUGS_DISK_CACHE_FILE_NAME = "/bugs.cache";

    public static InMemoryCache<String, Bug> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(BUGS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(BugsCacheManager.class, (String)("In-memory Bugs cache not found, loading it from disk " + CacheManager.getInstance().getCache(BUGS_MEMORY_CACHE_KEY)));
            CacheManager.getInstance().migrateCache(BUGS_DISK_CACHE_KEY, BUGS_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, Bug>(){

                public String a(Bug bug) {
                    return bug.getId();
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Bug)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(BUGS_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(BugsCacheManager.class, (String)("In-memory Bugs cache restored from disk, " + cache.getValues().size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(BugsCacheManager.class, (String)"In-memory Bugs cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(BUGS_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        Cache cache = CacheManager.getInstance().getCache(BUGS_MEMORY_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(BUGS_DISK_CACHE_KEY);
        if (cache != null && cache2 != null) {
            CacheManager.getInstance().migrateCache(cache, cache2, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, Bug>(){

                public String a(Bug bug) {
                    return bug.getId();
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Bug)object);
                }
            });
        }
    }

    public static void addBug(Bug bug) {
        InMemoryCache<String, Bug> inMemoryCache = BugsCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put((Object)bug.getId(), (Object)bug);
        }
        BugsCacheManager.sendBug(bug);
    }

    private static void sendBug(Bug bug) {
        if (bug.f() == Bug.BugState.READY_TO_BE_SENT) {
            InstabugSDKLogger.d(BugsCacheManager.class, (String)"sending bug report to the server");
            c.a(Instabug.getApplicationContext());
        }
    }

    @Nullable
    public static Bug getBug(String string2) {
        InMemoryCache<String, Bug> inMemoryCache = BugsCacheManager.getCache();
        if (inMemoryCache != null) {
            return (Bug)inMemoryCache.get((Object)string2);
        }
        return null;
    }

    public static List<Bug> getBugs() {
        InMemoryCache<String, Bug> inMemoryCache = BugsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.getValues();
        }
        return new ArrayList<Bug>();
    }

    @Nullable
    public static Bug deleteBug(String string2) {
        InMemoryCache<String, Bug> inMemoryCache = BugsCacheManager.getCache();
        if (inMemoryCache != null) {
            return (Bug)inMemoryCache.delete((Object)string2);
        }
        return null;
    }
}

