/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.network;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.LocalBroadcastManager;
import com.instabug.bug.model.Bug;
import com.instabug.bug.settings.a;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.observers.DisposableObserver;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class b {
    private static b b;
    private NetworkManager c = new NetworkManager();
    @VisibleForTesting
    Request a;

    public static b a() {
        if (b == null) {
            b = new b();
        }
        return b;
    }

    private b() {
    }

    public void a(Context context, Bug bug, Request.Callbacks<String, Throwable> callbacks) throws JSONException {
        InstabugSDKLogger.d((Object)this, (String)("Reporting a bug with message: " + bug.d()));
        this.a = this.a(context, bug);
        this.c.doRequest(this.a).subscribe(this.a(context, callbacks));
    }

    @VisibleForTesting
    Observer<RequestResponse> a(final Context context, final Request.Callbacks<String, Throwable> callbacks) {
        return new DisposableObserver<RequestResponse>(){

            public void onStart() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"reportingBugRequest started");
            }

            public void onComplete() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"reportingBugRequest completed");
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.e((Object)((Object)this), (String)("reportingBugRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                callbacks.onFailed((Object)throwable);
            }

            public void a(RequestResponse requestResponse) {
                InstabugSDKLogger.v((Object)((Object)this), (String)("reportingBugRequest onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
                try {
                    callbacks.onSucceeded((Object)new JSONObject((String)requestResponse.getResponseBody()).getString("id"));
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e((Object)((Object)this), (String)("reportingBugRequest onNext got error: " + jSONException.getMessage()), (Throwable)jSONException);
                }
                if (requestResponse.getResponseCode() == 200) {
                    Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
                    InstabugSDKLogger.d((Object)((Object)this), (String)("Updating last_contacted_at to " + calendar.getTime()));
                    com.instabug.bug.settings.a.a().a(calendar.getTime().getTime());
                    InstabugCore.setLastContactedAt((long)calendar.getTime().getTime());
                    Intent intent = new Intent();
                    intent.setAction("User last contact at changed");
                    intent.putExtra("last_contacted_at", calendar.getTime().getTime());
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                }
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((RequestResponse)object);
            }
        };
    }

    @VisibleForTesting
    Request a(Context context, Bug bug) throws JSONException {
        this.a = this.c.buildRequest(context, Request.Endpoint.ReportBug, Request.RequestMethod.Post);
        this.a(this.a, bug);
        this.a.addRequestBodyParameter("title", (Object)bug.d());
        this.a.addRequestBodyParameter("attachments_count", (Object)bug.e().size());
        this.a.addRequestBodyParameter("categories", (Object)bug.n());
        return this.a;
    }

    @VisibleForTesting
    void a(Request request, Bug bug) throws JSONException {
        ArrayList arrayList = bug.getState().getStateItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            InstabugSDKLogger.d((Object)this, (String)("Bug State Key: " + ((State.StateItem)arrayList.get(i)).getKey() + ", Bug State value: " + ((State.StateItem)arrayList.get(i)).getValue()));
            request.addRequestBodyParameter(((State.StateItem)bug.getState().getStateItems().get(i)).getKey(), ((State.StateItem)bug.getState().getStateItems().get(i)).getValue());
        }
    }

    public void b(Context context, final Bug bug, final Request.Callbacks<Boolean, Bug> callbacks) throws JSONException {
        InstabugSDKLogger.d((Object)this, (String)"Uploading Bug attachments");
        ArrayList<Observable<RequestResponse>> arrayList = this.b(context, bug);
        Observable.merge(arrayList, (int)1).subscribe((Observer)new DisposableObserver<RequestResponse>(){

            public void onStart() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"uploadingBugAttachmentRequest started");
            }

            public void onComplete() {
                InstabugSDKLogger.d((Object)((Object)this), (String)"uploadingBugAttachmentRequest completed");
                if (bug.e().size() == 0) {
                    callbacks.onSucceeded((Object)true);
                }
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.e((Object)((Object)this), (String)("uploadingBugAttachmentRequest got error: " + throwable.getMessage()), (Throwable)throwable);
                callbacks.onFailed((Object)bug);
            }

            public void a(RequestResponse requestResponse) {
                Attachment attachment;
                InstabugSDKLogger.d((Object)((Object)this), (String)("uploadingBugAttachmentRequest onNext, Response code: " + requestResponse.getResponseCode() + ", Response body: " + requestResponse.getResponseBody()));
                File file = new File(bug.e().get(0).getLocalPath());
                boolean bl = file.delete();
                if (bl) {
                    InstabugSDKLogger.d((Object)((Object)this), (String)"uploadingBugAttachmentRequest onNext, attachment file deleted successfully");
                }
                if ((attachment = bug.e().remove(0)).getId() != -1L) {
                    AttachmentsDbHelper.delete((long)attachment.getId());
                } else {
                    AttachmentsDbHelper.delete((String)attachment.getName(), (String)bug.getId());
                }
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((RequestResponse)object);
            }
        });
    }

    @VisibleForTesting
    ArrayList<Observable<RequestResponse>> b(Context context, Bug bug) throws JSONException {
        ArrayList<Observable<RequestResponse>> arrayList = new ArrayList<Observable<RequestResponse>>(bug.e().size());
        for (int i = 0; i < bug.e().size(); ++i) {
            File file;
            Attachment attachment = bug.e().get(i);
            Request request = this.c.buildRequest(context, Request.Endpoint.AddBugAttachment, Request.RequestMethod.Post, NetworkManager.RequestType.MULTI_PART);
            request.setEndpoint(request.getEndpoint().replaceAll(":bug_token", bug.a()));
            request.addParameter("metadata[file_type]", (Object)attachment.getType());
            if (attachment.getType() == Attachment.Type.AUDIO) {
                request.addParameter("metadata[duration]", (Object)attachment.getDuration());
            }
            if ((file = new File(attachment.getLocalPath())).exists() && file.length() > 0L) {
                attachment.setAttachmentState(Attachment.AttachmentState.SYNCED);
            } else {
                InstabugSDKLogger.e((Object)this, (String)("Skipping attachment file of type " + attachment.getType().name() + " because it's either not found or empty file"));
            }
            request.setFileToUpload(new Request.FileToUpload("file", attachment.getName(), attachment.getLocalPath(), attachment.getFileType()));
            arrayList.add((Observable<RequestResponse>)this.c.doRequest(request));
        }
        return arrayList;
    }

    public void c(Context context, final Bug bug, final Request.Callbacks<Boolean, Bug> callbacks) {
        try {
            Request request = this.c(context, bug);
            this.c.doRequest(request).subscribe((Observer)new DisposableObserver<RequestResponse>(){

                public void onStart() {
                    InstabugSDKLogger.d((Object)((Object)this), (String)"uploading bug logs started");
                }

                public void a(RequestResponse requestResponse) {
                    InstabugSDKLogger.v((Object)((Object)this), (String)("uploading bug logs onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody()));
                }

                public void onComplete() {
                    InstabugSDKLogger.d((Object)((Object)this), (String)"uploading bug logs completed");
                    callbacks.onSucceeded((Object)true);
                }

                public void onError(Throwable throwable) {
                    InstabugSDKLogger.d((Object)((Object)this), (String)("uploading bug logs got error: " + throwable.getMessage()));
                    callbacks.onFailed((Object)bug);
                }

                public /* synthetic */ void onNext(Object object) {
                    this.a((RequestResponse)object);
                }
            });
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.d((Object)this, (String)("uploading bug logs got Json error: " + jSONException.getMessage()));
            callbacks.onFailed((Object)bug);
        }
    }

    @VisibleForTesting
    Request c(Context context, Bug bug) throws JSONException {
        Request request = this.c.buildRequest(context, Request.Endpoint.bugLogs, Request.RequestMethod.Post);
        request.setEndpoint(request.getEndpoint().replaceAll(":bug_token", bug.a()));
        ArrayList arrayList = bug.getState().getLogsItems();
        for (State.StateItem stateItem : arrayList) {
            request.addRequestBodyParameter(stateItem.getKey(), stateItem.getValue());
        }
        if (bug.g() != null) {
            request.addRequestBodyParameter("view_hierarchy", (Object)bug.g());
        }
        return request;
    }
}

