/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.instabug.bug.OnSdkDismissedCallback;
import com.instabug.bug.PromptOption;
import com.instabug.bug.c;
import com.instabug.bug.cache.BugsCacheManager;
import com.instabug.bug.extendedbugreport.ExtendedBugReport;
import com.instabug.bug.invocation.InvocationMode;
import com.instabug.bug.model.Bug;
import com.instabug.bug.model.ReportCategory;
import com.instabug.bug.settings.AttachmentsTypesParams;
import com.instabug.bug.settings.a;
import com.instabug.bug.settings.b;
import com.instabug.chat.InstabugChat;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.OnSdkDismissedCallback;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.bugreporting.model.Bug;
import com.instabug.library.extendedbugreport.ExtendedBugReport;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.OnInvokeCallback;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.invocation.util.InstabugVideoRecordingButtonPosition;
import com.instabug.library.model.BugCategory;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BugReporting {
    public static void setInvocationEvents(InstabugInvocationEvent ... instabugInvocationEventArray) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue((Object)TextUtils.join((CharSequence)",", (Object[])instabugInvocationEventArray))});
        InvocationManager.getInstance().setInstabugInvocationEvent(instabugInvocationEventArray);
    }

    public static void invoke() throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InvocationManager.getInstance().invoke();
    }

    public static void invoke(@NonNull InvocationMode invocationMode, int ... nArray) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("invocationMode").setType(InvocationMode.class).setValue((Object)invocationMode.toString()), new Api.Parameter().setName("invocationOption").setValue(String.class).setValue((Object)Arrays.toString(nArray))});
        BugReporting.setInvocationOptions(nArray);
        switch (invocationMode) {
            case NEW_BUG: {
                InvocationManager.getInstance().invoke(1);
                break;
            }
            case NEW_FEEDBACK: {
                InvocationManager.getInstance().invoke(2);
                break;
            }
            case NEW_CHAT: {
                InvocationManager.getInstance().invoke(3);
                break;
            }
            case CHATS_LIST: {
                InvocationManager.getInstance().invoke(4);
                break;
            }
            default: {
                InvocationManager.getInstance().invoke(0);
            }
        }
    }

    public static void setInvocationOptions(int ... nArray) {
        APIBuildChecker.check();
        block6: for (int n : nArray) {
            switch (n) {
                case 8: {
                    a.a().c(true);
                    continue block6;
                }
                case 2: {
                    a.a().b(false);
                    a.a().a(false);
                    continue block6;
                }
                case 4: {
                    a.a().b(true);
                    a.a().a(false);
                    continue block6;
                }
                case 16: {
                    a.a().d(false);
                }
            }
        }
    }

    public static void setOnInvokeCallback(OnInvokeCallback onInvokeCallback) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("setOnInvokeCallback").setType(Runnable.class)});
        SettingsManager.getInstance().setOnInvokeCallback(onInvokeCallback);
    }

    public static void setOnDismissCallback(OnSdkDismissCallback onSdkDismissCallback) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("onSdkDismissedCallback").setType(com.instabug.library.OnSdkDismissedCallback.class)});
        InstabugChat.setOnSdkDismissCallback((OnSdkDismissCallback)onSdkDismissCallback);
        a.a().a(onSdkDismissCallback);
    }

    public static void setPromptOptionsEnabled(PromptOption ... promptOptionArray) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("promptOptions").setType(PromptOption.class).setValue(Arrays.asList(promptOptionArray))});
        c.a(promptOptionArray);
    }

    public static void setShakingThreshold(int n) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("threshold").setType(Integer.TYPE).setValue((Object)Integer.toString(n))});
        InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(n);
    }

    public static void setFloatingButtonEdge(@NonNull InstabugFloatingButtonEdge instabugFloatingButtonEdge) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugFloatingButtonEdge").setType(InstabugFloatingButtonEdge.class).setValue((Object)instabugFloatingButtonEdge)});
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge);
    }

    public static void setFloatingButtonOffset(@IntRange(from=0L) int n) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("floatingButtonOffsetFromTop").setType(Integer.TYPE).setValue((Object)Integer.toString(n))});
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(n);
    }

    public static void setVideoRecordingFloatingButtonPosition(@NonNull InstabugVideoRecordingButtonPosition instabugVideoRecordingButtonPosition) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugViewRecordingButtonPosition").setType(InstabugVideoRecordingButtonPosition.class).setValue((Object)instabugVideoRecordingButtonPosition)});
        InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(instabugVideoRecordingButtonPosition);
    }

    public static void setExtendedBugReportState(ExtendedBugReport.State state) {
        ExtendedBugReport.State state2;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        switch (state) {
            case ENABLED_WITH_REQUIRED_FIELDS: {
                state2 = ExtendedBugReport.State.ENABLED_WITH_REQUIRED_FIELDS;
                break;
            }
            case ENABLED_WITH_OPTIONAL_FIELDS: {
                state2 = ExtendedBugReport.State.ENABLED_WITH_OPTIONAL_FIELDS;
                break;
            }
            default: {
                state2 = ExtendedBugReport.State.DISABLED;
            }
        }
        a.a().a(state2);
    }

    private static void setLegacyReportCategories(List<com.instabug.library.bugreporting.model.ReportCategory> list) {
        ArrayList<ReportCategory> arrayList = new ArrayList<ReportCategory>();
        for (com.instabug.library.bugreporting.model.ReportCategory reportCategory : list) {
            ReportCategory reportCategory2 = ReportCategory.getInstance().withIcon(reportCategory.getIcon()).withLabel(reportCategory.getLabel());
            arrayList.add(reportCategory2);
        }
        BugReporting.setReportCategories(arrayList);
    }

    @Deprecated
    public static void setReportCategories(List<ReportCategory> list) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("reportCategories").setType(ReportCategory.class)});
        a.a().a(list);
    }

    private static void setLegacyBugCategories(List<BugCategory> list) {
        ArrayList<ReportCategory> arrayList = new ArrayList<ReportCategory>();
        for (BugCategory bugCategory : list) {
            ReportCategory reportCategory = ReportCategory.getInstance().withIcon(bugCategory.getIcon()).withLabel(bugCategory.getLabel());
            arrayList.add(reportCategory);
        }
        BugReporting.setReportCategories(arrayList);
    }

    private void updateBugCacheManager() {
        List<Bug> list = BugsCacheManager.getBugs();
        for (Bug bug : list) {
            if (bug.f() != Bug.BugState.WAITING_VIDEO) continue;
            InstabugSDKLogger.v((Object)this, (String)"found the video bug");
            bug.a(Bug.BugState.READY_TO_BE_SENT);
            BugsCacheManager.addBug(bug);
            break;
        }
    }

    private static void setLegacyOnSdkDismissedCallback(final com.instabug.library.OnSdkDismissedCallback onSdkDismissedCallback) throws IllegalStateException {
        OnSdkDismissedCallback onSdkDismissedCallback2 = new OnSdkDismissedCallback(){

            @Override
            public void onSdkDismissed(OnSdkDismissedCallback.DismissType dismissType, com.instabug.bug.model.b b2) {
                OnSdkDismissedCallback.DismissType dismissType2;
                Bug.Type type;
                switch (b2) {
                    case BUG: {
                        type = Bug.Type.BUG;
                        break;
                    }
                    case FEEDBACK: {
                        type = Bug.Type.FEEDBACK;
                        break;
                    }
                    case NOT_AVAILABLE: {
                        type = Bug.Type.NOT_AVAILABLE;
                        break;
                    }
                    default: {
                        type = Bug.Type.NOT_AVAILABLE;
                    }
                }
                switch (dismissType) {
                    case SUBMIT: {
                        dismissType2 = OnSdkDismissedCallback.DismissType.SUBMIT;
                        break;
                    }
                    case CANCEL: {
                        dismissType2 = OnSdkDismissedCallback.DismissType.CANCEL;
                        break;
                    }
                    case ADD_ATTACHMENT: {
                        dismissType2 = OnSdkDismissedCallback.DismissType.ADD_ATTACHMENT;
                        break;
                    }
                    default: {
                        dismissType2 = OnSdkDismissedCallback.DismissType.CANCEL;
                    }
                }
                onSdkDismissedCallback.onSdkDismissed(dismissType2, type);
            }
        };
        BugReporting.setOnSdkDismissedCallback(onSdkDismissedCallback2);
    }

    @Deprecated
    public static void setOnSdkDismissedCallback(OnSdkDismissedCallback onSdkDismissedCallback) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("onSdkDismissedCallback").setType(OnSdkDismissedCallback.class)});
        a.a().a(onSdkDismissedCallback);
    }

    public static void setAttachmentTypesEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("initialScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString(bl)), new Api.Parameter().setName("extraScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString(bl2)), new Api.Parameter().setName("galleryImage").setType(Boolean.class).setValue((Object)Boolean.toString(bl3)), new Api.Parameter().setName("screenRecording").setType(Boolean.class).setValue((Object)Boolean.toString(bl4))});
        AttachmentsTypesParams attachmentsTypesParams = new AttachmentsTypesParams(bl, bl2, bl3, bl4);
        a.a().a(attachmentsTypesParams);
    }

    @Deprecated
    public static Runnable getPreSendingRunnable() {
        return b.b().h();
    }

    @Deprecated
    public static void setPreSendingRunnable(Runnable runnable) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("runnable").setType(Runnable.class)});
        a.a().a(runnable);
    }

    @Deprecated
    public static void setShouldSkipInitialScreenshotAnnotation(boolean bl) {
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
    }

    @Deprecated
    public static void setEmailFieldRequired(boolean bl) {
        APIBuildChecker.check();
        a.a().a(bl);
    }

    @Deprecated
    public static void setEmailFieldVisibility(boolean bl) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("emailFieldVisibility").setType(Boolean.class).setValue((Object)Boolean.toString(bl))});
        a.a().b(bl);
    }

    @Deprecated
    public static void setCommentFieldRequired(boolean bl) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("commentFieldRequired").setType(Boolean.class).setValue((Object)Boolean.toString(bl))});
        a.a().c(bl);
    }

    @Deprecated
    public static void setSuccessDialogEnabled(boolean bl) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("enabled").setType(Boolean.class).setValue((Object)Boolean.toString(bl))});
        a.a().d(bl);
    }

    @Deprecated
    public static void openNewFeedback() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        com.instabug.bug.a.c();
    }

    @Deprecated
    public static void openNewBugReport() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        com.instabug.bug.a.d();
    }

    @Deprecated
    public static void addExtraReportField(CharSequence charSequence, boolean bl) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[]{new Api.Parameter().setName("fieldHint").setType(CharSequence.class).setValue((Object)charSequence), new Api.Parameter().setName("required").setType(Boolean.TYPE).setValue((Object)bl)});
        a.a().a(charSequence, bl);
    }

    @Deprecated
    public static void clearExtraReportFields() {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchDeprecatedApiUsage(new Api.Parameter[0]);
        a.a().n();
    }
}

