package com.instabug.chat.ui.annotation;

import android.annotation.SuppressLint;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;

import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;

import com.instabug.bug.R;
import com.instabug.chat.model.Attachment;
import com.instabug.chat.ui.chat.ChatFragment;
import com.instabug.chat.annotation.AnnotationLayout;
import com.instabug.chat.ui.base.ToolbarFragment;
import com.instabug.library.util.ThemeApplier;
import com.instabug.library.view.IBGProgressDialog;

@SuppressLint({"ERADICATE_FIELD_NOT_NULLABLE", "ERADICATE_FIELD_NOT_INITIALIZED"})
public class ChatAnnotationFragment extends ToolbarFragment<AnnotationContract.Presenter> implements
        AnnotationContract.View {

    public static final String TAG = "annotation_fragment_for_chat";
    private static final String EXTRA_TITLE = "title";
    private static final String EXTRA_CHAT_ID = "chat_id";
    private static final String EXTRA_IMAGE_URI = "image_uri";
    private static final String EXTRA_ATTACHMENT_TYPE = "attachment_type";

    private String title;
    private String chatId;
    private String attachmentType;
    private Uri imageUri;
    @Nullable
    private AnnotationLayout annotationLayout;
    private Callbacks callbacks;
    @Nullable
    private IBGProgressDialog preparingProgressDialog;

    public static ChatAnnotationFragment newInstance(String title, String chatId, Uri imageUri, @Attachment.AttachmentType String attachmentType) {
        ChatAnnotationFragment fragment = new ChatAnnotationFragment();
        Bundle args = new Bundle();
        args.putString(EXTRA_TITLE, title);
        args.putString(EXTRA_CHAT_ID, chatId);
        args.putParcelable(EXTRA_IMAGE_URI, imageUri);
        args.putString(EXTRA_ATTACHMENT_TYPE, attachmentType);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (getActivity() != null && getActivity().getSupportFragmentManager().findFragmentByTag(ChatFragment.TAG) != null) {
            callbacks = (Callbacks) getActivity().getSupportFragmentManager().findFragmentByTag(ChatFragment.TAG);
        }
        if (getArguments() != null) {
            title = getArguments().getString(EXTRA_TITLE);
            chatId = getArguments().getString(EXTRA_CHAT_ID);
            attachmentType = getArguments().getString(EXTRA_ATTACHMENT_TYPE);
            imageUri = getArguments().getParcelable(EXTRA_IMAGE_URI);
        }
        presenter = new AnnotationPresenter(this);
    }

    @Override
    protected int getContentLayout() {
        return R.layout.instabug_fragment_annotation;
    }

    @Override
    protected void initContentViews(View rootView, @Nullable Bundle savedInstanceState) {
        // init send button
        ImageButton doneButton = rootView.findViewById(R.id.instabug_btn_toolbar_right);
        if (doneButton != null)
            doneButton.setImageResource(R.drawable.ibg_chat_ic_send);
        //init annotation layout
        annotationLayout = rootView.findViewById(R.id.annotationLayout);
        if (annotationLayout != null) {
            annotationLayout.setBaseImage(imageUri, null);
        }

        LinearLayout actionContainer = rootView.findViewById(R.id.instabug_annotation_actions_container);
        if (theme != null && theme.getBackgroundColor() != ThemeApplier.DEFAULT_COLOR && actionContainer != null) {
            actionContainer.setBackgroundColor(Color.TRANSPARENT);
        }
    }

    protected String getTitle() {
        return title;
    }

    @Override
    protected void onDoneButtonClicked() {
        if (presenter != null && annotationLayout != null) {
            presenter.saveAnnotatedImage(annotationLayout.getAnnotatedBitmap(), imageUri);
        }
    }

    @Override
    protected void onCloseButtonClicked() {
        if (callbacks != null) {
            callbacks.onImageEditingCancelled(chatId, imageUri);
        }
    }

    @Override
    public void showPreparingDialog() {
        if (getActivity() != null && preparingProgressDialog != null) {
            preparingProgressDialog = new IBGProgressDialog.Builder()
                    .setMessage(getLocalizedString(R.string.instabug_str_dialog_message_preparing))
                    .build(getActivity());
            preparingProgressDialog.show();
        }
    }

    @Override
    public void finish() {
        if (preparingProgressDialog != null && preparingProgressDialog.isShowing()) {
            preparingProgressDialog.dismiss();
        }
        if (callbacks != null) {
            callbacks.onImageEditingDone(chatId, imageUri, attachmentType);
        }
        if (getActivity() != null) {
            getActivity().getSupportFragmentManager().beginTransaction().remove(this).commit();
            getActivity().getSupportFragmentManager().popBackStack(TAG, FragmentManager
                    .POP_BACK_STACK_INCLUSIVE);
        }
    }

    public interface Callbacks {
        void onImageEditingDone(String chatId, Uri annotatedImageUri, @Attachment.AttachmentType String attachmentType);

        void onImageEditingCancelled(String chatId, Uri baseImageUri);
    }
}
