package com.instabug.bug.settings;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;

import androidx.annotation.Nullable;

import com.instabug.library.Instabug;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;

/**
 * Created by mohamedzakaria on 6/11/17.
 */

public class PersistableSettings {
    private static final String IB_LAST_BUG_TIME = "last_bug_time";

    private static final String INSTABUG_BUGREPORTING_SHARED_PREF_NAME = "instabug_bug_reporting";
    private static final String IB_REMOTE_REPORT_CATEGORIES = "ib_remote_report_categories";
    private static final String IB_REPORT_CATEGORIES_LAST_FETCHED_TIME = "report_categories_fetched_time";
    private static final String IB_IS_FIRST_RUN_AFTER_ENCRYPTOR_UPDATE = "ib_first_run_after_updating_encryptor";
    private static final String IB_BD_ENCRYPTION_MIGRATION_STATUS = "ib_encryption_migration_status";
    @Nullable
    private SharedPreferences sharedPreferences;
    @Nullable
    private SharedPreferences.Editor sharedPreferencesEditor;
    @Nullable
    private static PersistableSettings persistableSettings;

    private PersistableSettings(Context context) {
        sharedPreferences = CoreServiceLocator.getInstabugSharedPreferences(context, INSTABUG_BUGREPORTING_SHARED_PREF_NAME);
        if (sharedPreferences != null) {
            sharedPreferencesEditor = sharedPreferences.edit();
        }
    }

    public synchronized static void init(Context context) {
        persistableSettings = new PersistableSettings(context);
    }

    /**
     * Returns the current singleton instance of this class.
     *
     * @return a {@code PersistableSettings} instance
     */
    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    public synchronized static PersistableSettings getInstance() {
        if (persistableSettings == null && Instabug.getApplicationContext() != null) {
            init(Instabug.getApplicationContext());
        }
        return persistableSettings;
    }

    public long getLastBugTime() {
        if (sharedPreferences == null) return 0L;
        return sharedPreferences.getLong(IB_LAST_BUG_TIME, 0L);
    }

    public void setLastBugTime(long time) {
        if (sharedPreferencesEditor == null) return;
        sharedPreferencesEditor.putLong(IB_LAST_BUG_TIME, time);
        sharedPreferencesEditor.apply();
    }

    @Nullable
    String getRemoteReportCategories() {
        if (sharedPreferences == null) return null;
        return sharedPreferences.getString(IB_REMOTE_REPORT_CATEGORIES, null);
    }

    public void setRemoteReportCategories(@Nullable String remoteReportCategories) {
        if (sharedPreferencesEditor == null) return;
        sharedPreferencesEditor.putString(IB_REMOTE_REPORT_CATEGORIES, remoteReportCategories);
        sharedPreferencesEditor.apply();
    }

    public long getReportCategoriesLastFetchedTime() {
        if (sharedPreferences == null) return 0L;
        return sharedPreferences.getLong(IB_REPORT_CATEGORIES_LAST_FETCHED_TIME, 0L);
    }

    public void setReportCategoriesLastFetchedTime(long time) {
        if (sharedPreferencesEditor == null) return;
        sharedPreferencesEditor.putLong(IB_REPORT_CATEGORIES_LAST_FETCHED_TIME, time);
        sharedPreferencesEditor.apply();
    }

    public synchronized static void release() {
        persistableSettings = null;
    }


    public boolean isFirstRunAfterEncryptorUpdate() {
        // Defaults to true if not set before
        if (sharedPreferences == null) return true;
        return sharedPreferences.getBoolean(IB_IS_FIRST_RUN_AFTER_ENCRYPTOR_UPDATE, true);
    }

    public void setFirstRunAfterEncryptorUpdate(boolean isFirstRun) {
        if (sharedPreferencesEditor == null) return;
        sharedPreferencesEditor.putBoolean(IB_IS_FIRST_RUN_AFTER_ENCRYPTOR_UPDATE, isFirstRun);
        sharedPreferencesEditor.apply();
    }

    public void setDbEncryptionMigrationStatus(boolean status) {
        if (sharedPreferencesEditor == null) return;
        sharedPreferencesEditor.putBoolean(IB_BD_ENCRYPTION_MIGRATION_STATUS, status);
        sharedPreferencesEditor.apply();
    }

    public boolean getDbEncryptionMigrationStatus() {
        if (sharedPreferences == null) return true;
        return sharedPreferences.getBoolean(IB_BD_ENCRYPTION_MIGRATION_STATUS, true);
    }
}
