package com.instabug.bug.settings;

import android.os.Build;

import java.io.Serializable;

/**
 * @author mesbah
 */
public class AttachmentsTypesParams implements Serializable {

    private boolean shouldTakesInitialScreenshot;
    private boolean allowTakeExtraScreenshot;
    private boolean allowAttachImageFromGallery;
    private boolean allowScreenRecording;

    public AttachmentsTypesParams() {
        shouldTakesInitialScreenshot = true;
        allowTakeExtraScreenshot = true;
        allowAttachImageFromGallery = true;
        allowScreenRecording = true;
    }

    public AttachmentsTypesParams(boolean shouldTakesInitialScreenshot, boolean allowTakeExtraScreenshot, boolean allowAttachImageFromGallery, boolean allowScreenRecording) {
        this.shouldTakesInitialScreenshot = shouldTakesInitialScreenshot;
        this.allowTakeExtraScreenshot = allowTakeExtraScreenshot;
        this.allowAttachImageFromGallery = allowAttachImageFromGallery;
        this.allowScreenRecording = allowScreenRecording;
    }

    public boolean isShouldTakesInitialScreenshot() {
        return shouldTakesInitialScreenshot;
    }

    public AttachmentsTypesParams setShouldTakesInitialScreenshot(boolean shouldTakesInitialScreenshot) {
        this.shouldTakesInitialScreenshot = shouldTakesInitialScreenshot;
        return this;
    }

    public boolean isAllowTakeExtraScreenshot() {
        return allowTakeExtraScreenshot;
    }

    public AttachmentsTypesParams setAllowTakeExtraScreenshot(boolean allowTakeExtraScreenshot) {
        this.allowTakeExtraScreenshot = allowTakeExtraScreenshot;
        return this;
    }

    public boolean isAllowAttachImageFromGallery() {
        return allowAttachImageFromGallery;
    }

    public AttachmentsTypesParams setAllowAttachImageFromGallery(boolean allowAttachImageFromGallery) {
        this.allowAttachImageFromGallery = allowAttachImageFromGallery;
        return this;
    }

    public boolean isAllowScreenRecording() {
        return allowScreenRecording && Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP;
    }

    public AttachmentsTypesParams setAllowScreenRecording(boolean allowScreenRecording) {
        this.allowScreenRecording = allowScreenRecording;
        return this;
    }

    @Override
    public String toString() {
        return shouldTakesInitialScreenshot + ", " + allowTakeExtraScreenshot + ", " + allowAttachImageFromGallery
                + ", " + allowScreenRecording;
    }
}
