package com.instabug.bug.view.disclaimer;

import com.instabug.bug.utils.DisclaimersLinksUtils;

import java.io.Serializable;

/**
 * Created by tarek on 8/11/17.
 */

public class Disclaimer implements Serializable {

    private String key;
    private String value;
    private boolean isLog = false;

    public Disclaimer(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public Disclaimer setLog(boolean log) {
        isLog = log;
        return this;
    }

    public Disclaimer setKey(String key) {
        this.key = key;
        return this;
    }

    public Disclaimer setValue(String value) {
        this.value = value;
        return this;
    }

    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public boolean isLog() {
        return isLog;
    }

    public static String convertMarkdownLinksToHTMLHyperLinks(String markdown, int linkTextColor) {
        return DisclaimersLinksUtils.convertMarkdownLinksToHTMLHyperLinks(markdown, linkTextColor);
    }

    public static String replaceMetadataLinkWithInstabugScheme(String markdown, String linkPlaceHolder, String uri) {
        return DisclaimersLinksUtils.replacePlaceholderLinkWithInstabugScheme(markdown, linkPlaceHolder, uri);
    }
}
