package com.instabug.bug.proactivereporting.configs

import com.instabug.bug.di.ServiceLocator
import org.json.JSONObject
import java.util.concurrent.TimeUnit

interface ProactiveReportingConfigHandler {
    fun handle(json: JSONObject?)
}

val ENABLED_KEY = "enabled" to true
val DROP_LOGS_KEY = "drop_state_logs" to true
val MODALS_GAP_KEY = "gap_between_modals_seconds" to TimeUnit.HOURS.toSeconds(24)
val DETECTION_GAP_KEY = "modal_delay_after_detection_seconds" to 2L

object ProactiveReportingConfigHandlerImpl : ProactiveReportingConfigHandler {

    private val configurationsProvider: ProactiveReportingConfigProvider
        get() = ServiceLocator.getProactiveReportingConfigProvider()

    override fun handle(json: JSONObject?) {
        json?.let { jsonObject ->
            configurationsProvider.proactiveReportingBEAvailability =
                jsonObject.optBoolean(ENABLED_KEY.first, ENABLED_KEY.second)
            configurationsProvider.shouldDropLogs =
                jsonObject.optBoolean(DROP_LOGS_KEY.first, DROP_LOGS_KEY.second)
            configurationsProvider.modalsGapBEValue =
                jsonObject.optLong(MODALS_GAP_KEY.first, MODALS_GAP_KEY.second)
            configurationsProvider.detectionGapBEValue =
                jsonObject.optLong(DETECTION_GAP_KEY.first, DETECTION_GAP_KEY.second)
        }
    }

}