package com.instabug.bug.onboardingbugreporting;

import androidx.annotation.StringRes;
import androidx.appcompat.app.AppCompatActivity;
import com.instabug.library.core.ui.BaseContract;
import java.util.List;

public interface OnBoardingActivityContract {
    interface View extends BaseContract.View<AppCompatActivity> {

        void loadViewPager(List<OnboardingPagerFragment> betaFragments);

        void dismiss();

        void handlePowerByInstabugFooter();

        void enableClickToClose();

        String getLocalizedString(@StringRes int resourceId);

    }
    interface Presenter {
        void startWithBetaVersion();

        void startWithLiveVersion();

        void start(@State int state);
    }
}
